/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.util.Map;
import java.util.concurrent.Future;
import org.jppf.classloader.CompositeResourceWrapper;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceFuture;
import org.jppf.classloader.ResourceRequestRunner;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.StringUtils;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderRequestHandler {
    private static Logger log = LoggerFactory.getLogger(ClassLoaderRequestHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final long MAX_WAIT = JPPFConfiguration.getProperties().getLong("jppf.node.classloading.batch.period", 100L);
    private static final int NANO_RANGE = 1000000;
    private CompositeResourceWrapper nextRequest = null;
    private ResourceRequestRunner requestRunner;
    private PeriodicTask periodicTask = new PeriodicTask();
    private Thread periodicThread = null;
    private int maxBatchSize = 0;

    public ClassLoaderRequestHandler(ResourceRequestRunner requestRunner) {
        this.nextRequest = new CompositeResourceWrapper();
        this.requestRunner = requestRunner;
        this.periodicThread = new Thread((Runnable)this.periodicTask, "PeriodicTask");
        this.periodicThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<JPPFResourceWrapper> addRequest(JPPFResourceWrapper resource) {
        Future f;
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        resource.preProcess();
        PeriodicTask periodicTask = this.periodicTask;
        synchronized (periodicTask) {
            f = this.nextRequest.addResource(resource);
        }
        this.periodicTask.wakeUp();
        return f;
    }

    public ResourceRequestRunner close() {
        if (debugEnabled) {
            log.debug("closing request handler");
        }
        this.periodicTask.setStopped(true);
        this.periodicThread.interrupt();
        ResourceRequestRunner tmp = this.requestRunner;
        this.requestRunner = null;
        this.periodicThread = null;
        this.periodicTask = null;
        return tmp;
    }

    public ResourceRequestRunner getRequestRunner() {
        return this.requestRunner;
    }

    private class PeriodicTask
    extends ThreadSynchronization
    implements Runnable {
        private PeriodicTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long elapsed = 0L;
                while (!this.isStopped()) {
                    CompositeResourceWrapper request = null;
                    long start = System.nanoTime();
                    PeriodicTask periodicTask = this;
                    synchronized (periodicTask) {
                        while (ClassLoaderRequestHandler.this.nextRequest.getFutureMap().isEmpty() && !this.isStopped()) {
                            this.goToSleep();
                        }
                        while ((elapsed = System.nanoTime() - start) < MAX_WAIT && !this.isStopped()) {
                            this.goToSleep((MAX_WAIT - elapsed) / 1000000L, (int)((MAX_WAIT - elapsed) % 1000000L));
                        }
                        if (this.isStopped()) {
                            return;
                        }
                        request = ClassLoaderRequestHandler.this.nextRequest;
                        ClassLoaderRequestHandler.this.nextRequest = new CompositeResourceWrapper();
                    }
                    Map futureMap = request.getFutureMap();
                    int n = futureMap.size();
                    if (n > ClassLoaderRequestHandler.this.maxBatchSize) {
                        ClassLoaderRequestHandler.this.maxBatchSize = n;
                        log.info(StringUtils.build((Object[])new Object[]{"maxBatchSize = ", ClassLoaderRequestHandler.this.maxBatchSize}));
                    }
                    if (debugEnabled) {
                        log.debug(StringUtils.build((Object[])new Object[]{"sending batch of ", futureMap.size(), " class loading requests: ", request}));
                    }
                    if (this.isStopped()) {
                        return;
                    }
                    ClassLoaderRequestHandler.this.requestRunner.setRequest((JPPFResourceWrapper)request);
                    ClassLoaderRequestHandler.this.requestRunner.run();
                    Throwable t = ClassLoaderRequestHandler.this.requestRunner.getThrowable();
                    CompositeResourceWrapper response = (CompositeResourceWrapper)ClassLoaderRequestHandler.this.requestRunner.getResponse();
                    if (debugEnabled) {
                        log.debug(StringUtils.build((Object[])new Object[]{"got response ", response}));
                    }
                    if (response != null) {
                        for (JPPFResourceWrapper rw : response.getResources()) {
                            ResourceFuture f = (ResourceFuture)futureMap.remove(rw);
                            if (f == null) continue;
                            f.setDone(rw);
                        }
                    }
                    for (Map.Entry entry : futureMap.entrySet()) {
                        ResourceFuture future = (ResourceFuture)entry.getValue();
                        if (t != null) {
                            future.setThrowable(t);
                            continue;
                        }
                        future.setDone(null);
                    }
                    futureMap.clear();
                    ClassLoaderRequestHandler.this.requestRunner.reset();
                    start = System.nanoTime();
                    elapsed = 0L;
                }
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                log.warn(ExceptionUtils.getMessage((Throwable)e));
            }
        }
    }
}

