/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.IOException;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.classloader.AbstractClassLoaderConnection;
import org.jppf.classloader.RemoteResourceRequest;
import org.jppf.classloader.ResourceRequestRunner;
import org.jppf.comm.socket.BootstrapObjectSerializer;
import org.jppf.comm.socket.BootstrapSocketClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.node.connection.DriverConnectionInfo;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClassLoaderConnection
extends AbstractClassLoaderConnection<SocketWrapper> {
    private static Logger log = LoggerFactory.getLogger(AbstractClassLoaderConnection.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private SocketInitializer socketInitializer = new SocketInitializerImpl();
    private boolean sslEnabled = false;
    private ObjectSerializer serializer = null;
    private final DriverConnectionInfo connectionInfo;

    public RemoteClassLoaderConnection(DriverConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        block8: {
            this.lock.lock();
            try {
                if (!this.initializing.compareAndSet(false, true)) break block8;
                try {
                    if (debugEnabled) {
                        log.debug("initializing connection");
                    }
                    this.initChannel();
                    System.out.println("Attempting connection to the class server at " + ((SocketWrapper)this.channel).getHost() + ':' + ((SocketWrapper)this.channel).getPort());
                    this.socketInitializer.initializeSocket((SocketWrapper)this.channel);
                    if (!this.socketInitializer.isSuccessful()) {
                        this.channel = null;
                        throw new JPPFNodeReconnectionNotification("the JPPF class loader could not reconnect to the server", null, ConnectionReason.CLASSLOADER_INIT_ERROR);
                    }
                    this.performHandshake();
                    System.out.println(StringUtils.build((Object[])new Object[]{this.getClass().getSimpleName(), ": Reconnected to the class server"}));
                }
                finally {
                    this.initializing.set(false);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void createSSLConnection() {
        try {
            this.channel = SSLHelper.createSSLClientConnection((SocketWrapper)((SocketWrapper)this.channel));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void performHandshake() {
        try {
            if (debugEnabled) {
                log.debug("sending channel identifier");
            }
            ((SocketWrapper)this.channel).writeInt(65533);
            ((SocketWrapper)this.channel).flush();
            if (this.sslEnabled) {
                this.createSSLConnection();
            }
            RemoteResourceRequest rr = new RemoteResourceRequest(this.getSerializer(), (SocketWrapper)this.channel);
            this.performCommonHandshake(rr);
        }
        catch (IOException e) {
            throw new JPPFNodeReconnectionNotification("Could not reconnect to the driver", e, ConnectionReason.CLASSLOADER_INIT_ERROR);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initChannel() {
        if (debugEnabled) {
            log.debug("initializing socket connection");
        }
        this.sslEnabled = this.connectionInfo.isSecure();
        this.channel = new BootstrapSocketClient();
        ((SocketWrapper)this.channel).setHost(this.connectionInfo.getHost());
        ((SocketWrapper)this.channel).setPort(this.connectionInfo.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block7: {
            this.lock.lock();
            try {
                block8: {
                    if (this.requestHandler != null) {
                        ResourceRequestRunner requestRunner = this.requestHandler.close();
                        this.requestHandler = null;
                        this.sendCloseChannelCommand(requestRunner);
                    }
                    if (this.socketInitializer != null) {
                        this.socketInitializer.close();
                    }
                    if (this.channel == null) break block7;
                    try {
                        ((SocketWrapper)this.channel).close();
                    }
                    catch (Exception e) {
                        if (!debugEnabled) break block8;
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                }
                this.channel = null;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private ObjectSerializer getSerializer() throws Exception {
        if (this.serializer == null) {
            this.serializer = new BootstrapObjectSerializer();
        }
        return this.serializer;
    }
}

