/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader.resource;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jppf.classloader.resource.SaveResourceAction;
import org.jppf.location.FileLocation;
import org.jppf.location.Location;
import org.jppf.location.MemoryLocation;
import org.jppf.location.URLLocation;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.VectorHashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCache {
    private static Logger log = LoggerFactory.getLogger(ResourceCache.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static boolean traceEnabled = log.isTraceEnabled();
    private static final Map<String, ResourceCache> cacheMap = new Hashtable<String, ResourceCache>();
    private static String ROOT_NAME = ".jppf";
    private CollectionMap<String, Location> cache = new VectorHashtable();
    private List<String> tempFolders = new LinkedList<String>();
    private final String uuid = new JPPFUuid(JPPFUuid.HEXADECIMAL_CHAR, 32).toString();
    private ShutdownHook shutdownHook = null;
    private final boolean enabled;

    public ResourceCache(boolean enabled) {
        this.enabled = enabled;
        if (this.enabled) {
            this.shutdownHook = new ShutdownHook(this.tempFolders, this.uuid);
            this.shutdownHook.setContextClassLoader(null);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.initTempFolders();
        }
        cacheMap.put(this.uuid, this);
    }

    public synchronized List<Location> getResourcesLocations(String name) {
        return this.enabled ? (List)this.cache.getValues((Object)name) : null;
    }

    private synchronized Location getResourceLocation(String name) {
        Collection locations = this.cache.getValues((Object)name);
        if (locations == null || locations.isEmpty()) {
            return null;
        }
        return (Location)locations.iterator().next();
    }

    private synchronized void setResourcesLocations(String name, List<Location> locations) {
        this.cache.addValues((Object)name, locations);
    }

    public synchronized List<URL> getResourcesURLs(String name) {
        if (!this.enabled) {
            return null;
        }
        List<Location> resources = this.getResourcesLocations(name);
        if (resources == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>(resources.size());
        int count = 0;
        for (Location res : resources) {
            URL url = this.getResourceURL(name, res, count++);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    public URL getResourceURL(String name) {
        return this.enabled ? this.getResourceURL(name, this.getResourceLocation(name), 0) : null;
    }

    private synchronized URL getResourceURL(String name, Location res, int id) {
        if (res instanceof FileLocation) {
            String path = (String)((FileLocation)res).getPath();
            if (path == null) {
                return null;
            }
            return FileUtils.getURLFromFilePath((String)path);
        }
        if (res instanceof MemoryLocation) {
            String s = "jppfres://" + this.uuid + '/' + name + "?id=" + id;
            try {
                return new URL(s);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (res instanceof URLLocation) {
            return (URL)((URLLocation)res).getPath();
        }
        return null;
    }

    public synchronized void registerResources(String name, List<byte[]> definitions) {
        if (!this.enabled) {
            return;
        }
        if (this.isAbsolutePath(name)) {
            return;
        }
        LinkedList<Location> locations = new LinkedList<Location>();
        for (byte[] def : definitions) {
            try {
                locations.add(this.saveToTempFile(name, def));
            }
            catch (Exception e) {
                String s = "Exception caught while saving resource named '" + name + "' : ";
                if (debugEnabled) {
                    log.debug(s, (Throwable)e);
                    continue;
                }
                log.warn(s + ExceptionUtils.getMessage((Throwable)e));
            }
        }
        if (!locations.isEmpty()) {
            this.setResourcesLocations(name, locations);
        }
    }

    public synchronized void registerResource(String name, Location location) {
        if (this.enabled) {
            this.cache.putValue((Object)name, (Object)location);
        }
    }

    private Location saveToTempFile(String name, byte[] definition) throws Exception {
        SaveResourceAction action = new SaveResourceAction(this.tempFolders, name, definition);
        Location file = AccessController.doPrivileged(action);
        if (action.getException() != null) {
            throw action.getException();
        }
        if (traceEnabled) {
            log.trace("saved resource [" + name + "] to file " + file);
        }
        return file;
    }

    private void initTempFolders() {
        try {
            String base = JPPFConfiguration.getProperties().getString("jppf.resource.cache.dir", null);
            if (base == null) {
                base = System.getProperty("java.io.tmpdir");
                if (base == null) {
                    base = System.getProperty("user.home");
                }
                if (base == null) {
                    base = System.getProperty("user.dir");
                }
                if (base != null) {
                    if (!base.endsWith(File.separator)) {
                        base = base + File.separator;
                    }
                    base = base + ROOT_NAME;
                }
            }
            if (base == null) {
                base = "." + File.separator + ROOT_NAME;
            }
            if (traceEnabled) {
                log.trace("base = " + base);
            }
            String s = base + File.separator + this.uuid;
            File baseDir = new File(s + File.separator);
            FileUtils.mkdirs((File)baseDir);
            this.tempFolders.add(s);
            if (traceEnabled) {
                log.trace("added temp folder " + s);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isAbsolutePath(String path) {
        if (path.startsWith("/") || path.startsWith("\\")) {
            return true;
        }
        if (path.length() < 3) {
            return false;
        }
        char c = path.charAt(0);
        return (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && path.charAt(1) == ':';
    }

    public synchronized void close() {
        if (this.enabled) {
            block4: {
                try {
                    if (this.shutdownHook != null) {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                    }
                }
                catch (Exception e) {
                    if (!debugEnabled) break block4;
                    log.debug("could not deregister shutdown hook", (Throwable)e);
                }
            }
            new ShutdownHook(this.tempFolders, this.uuid).run();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String getUuid() {
        return this.uuid;
    }

    public static ResourceCache getCacheInstance(String uuid) {
        return cacheMap.get(uuid);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static final class ShutdownHook
    extends Thread {
        private final List<String> tempResourceFolders;
        private final String uuid;

        private ShutdownHook(List<String> tempFolders, String uuid) {
            this.tempResourceFolders = tempFolders;
            this.uuid = uuid;
        }

        @Override
        public void run() {
            ResourceCache rc = (ResourceCache)cacheMap.remove(this.uuid);
            if (rc != null) {
                rc.cache.clear();
                rc = null;
            }
            while (!this.tempResourceFolders.isEmpty()) {
                FileUtils.deletePath((File)new File(this.tempResourceFolders.remove(0)));
            }
        }
    }
}

