/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader.resource.protocol.jppfres;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.jppf.classloader.resource.ResourceCache;
import org.jppf.location.Location;

public class JPPFResourceConnection
extends URLConnection {
    private Location resource = null;
    private boolean connectionFailed = false;

    public JPPFResourceConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        try {
            char c;
            ResourceCache rc = ResourceCache.getCacheInstance(this.url.getHost());
            StringBuilder path = new StringBuilder(this.url.getPath());
            while ((c = path.charAt(0)) == '/' || c == '\\') {
                path.deleteCharAt(0);
            }
            String[] keyvalue = this.url.getQuery().split("\\?|=");
            int id = Integer.valueOf(keyvalue[1]);
            List<Location> list = rc.getResourcesLocations(path.toString());
            if (list == null) {
                throw new IOException("URL '" + this.url + "' does not point to an existing or valid resource");
            }
            this.resource = list.get(id);
            this.connected = true;
        }
        catch (Exception e) {
            this.connectionFailed = true;
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return (InputStream)this.createStream(true);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return (OutputStream)this.createStream(false);
    }

    private Object createStream(boolean isInputStream) throws IOException {
        this.checkValid();
        try {
            return isInputStream ? this.resource.getInputStream() : this.resource.getOutputStream();
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }

    private void checkValid() throws IOException {
        if (!this.connected) {
            if (this.connectionFailed) {
                throw new IOException("URL '" + this.url + "' does not point to an existing or valid resource");
            }
            this.connect();
        }
        if (this.resource == null) {
            throw new IOException("URL '" + this.url + "' does not point to an existing or valid resource");
        }
    }
}

