/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.JPPFException;
import org.jppf.JPPFInitializer;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.JPPFClassLoader;
import org.jppf.classloader.RemoteClassLoaderConnection;
import org.jppf.logging.jmx.JmxMessageNotifier;
import org.jppf.node.Node;
import org.jppf.node.NodeInternal;
import org.jppf.node.ShutdownRestartNodeProtocolHandler;
import org.jppf.node.connection.ConnectionContext;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.node.connection.DriverConnectionInfo;
import org.jppf.node.connection.DriverConnectionStrategy;
import org.jppf.node.connection.JPPFDefaultConnectionStrategy;
import org.jppf.node.initialization.InitializationHook;
import org.jppf.process.LauncherListener;
import org.jppf.process.LauncherListenerProtocolHandler;
import org.jppf.security.JPPFPolicy;
import org.jppf.server.node.JPPFNode;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFDefaultUncaughtExceptionHandler;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.SimpleObjectLock;
import org.jppf.utils.SystemUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.UnmodifiableTypedProperties;
import org.jppf.utils.VersionUtils;
import org.jppf.utils.hooks.HookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRunner {
    private static Logger log;
    private static boolean debugEnabled;
    private static AbstractJPPFClassLoader classLoader;
    private static boolean securityManagerSet;
    private static Hashtable<Object, Object> persistentData;
    private static ExecutorService executor;
    private static JPPFNode node;
    private static SimpleObjectLock serviceLock;
    private static String uuid;
    private static boolean offline;
    private static TypedProperties initialConfig;
    private static AtomicBoolean shuttingDown;
    private static DriverConnectionInfo currentConnectionInfo;
    private static LauncherListener launcherListener;
    private static boolean ANDROID;

    public static void main(String ... args) {
        node = null;
        try {
            if (!ANDROID) {
                new JmxMessageNotifier();
            }
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JPPFDefaultUncaughtExceptionHandler());
            if (debugEnabled) {
                log.debug("launching the JPPF node");
            }
            VersionUtils.logVersionInformation((String)"node", (String)uuid);
            HookFactory.registerSPIMultipleHook(InitializationHook.class, null, null);
            HookFactory.registerConfigSingleHook((String)"jppf.server.connection.strategy", DriverConnectionStrategy.class, (Object)new JPPFDefaultConnectionStrategy(), null);
            if (args == null || args.length <= 0) {
                throw new JPPFException("The node should be run with an argument representing a valid TCP port or 'noLauncher'");
            }
            if (!"noLauncher".equals(args[0])) {
                int port = Integer.parseInt(args[0]);
                launcherListener = new LauncherListener(port);
                launcherListener.start();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
        try {
            ConnectionContext context = new ConnectionContext("Initial connection", null, ConnectionReason.INITIAL_CONNECTION_REQUEST);
            while (!NodeRunner.getShuttingDown().get()) {
                try {
                    if (initialConfig == null) {
                        initialConfig = new TypedProperties((Map)JPPFConfiguration.getProperties());
                    } else {
                        NodeRunner.restoreInitialConfig();
                    }
                    node = NodeRunner.createNode(context);
                    if (launcherListener != null) {
                        launcherListener.setActionHandler((LauncherListenerProtocolHandler)new ShutdownRestartNodeProtocolHandler(node));
                    }
                    node.run();
                }
                catch (JPPFNodeReconnectionNotification e) {
                    if (debugEnabled) {
                        log.debug("received reconnection notification : {}", (Object)ExceptionUtils.getStackTrace((Throwable)((Object)e)));
                    }
                    context = new ConnectionContext(e.getMessage(), e.getCause(), e.getReason());
                    if (classLoader != null) {
                        classLoader.close();
                    }
                    classLoader = null;
                    if (node != null) {
                        node.stopNode();
                    }
                    NodeRunner.unsetSecurity();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void start(String ... args) {
        NodeRunner.main(args);
        serviceLock.goToSleep();
    }

    public static void stop(String ... args) {
        serviceLock.wakeUp();
        System.exit(0);
    }

    public static JPPFNode createNode(ConnectionContext connectionContext) throws Exception {
        HookFactory.invokeHook(InitializationHook.class, (String)"initializing", (Object[])new Object[]{new UnmodifiableTypedProperties((Map)initialConfig)});
        SystemUtils.printPidAndUuid((String)"node", (String)uuid);
        currentConnectionInfo = (DriverConnectionInfo)HookFactory.invokeHook(DriverConnectionStrategy.class, (String)"nextConnectionInfo", (Object[])new Object[]{currentConnectionInfo, connectionContext})[0];
        NodeRunner.setSecurity();
        String className = JPPFConfiguration.getProperties().getString("jppf.node.class", "org.jppf.server.node.remote.JPPFRemoteNode");
        Class<?> clazz = NodeRunner.getJPPFClassLoader().loadClass(className);
        Constructor<?> c = clazz.getConstructor(DriverConnectionInfo.class);
        JPPFNode node = (JPPFNode)c.newInstance(currentConnectionInfo);
        if (debugEnabled) {
            log.debug("Created new node instance: " + node);
        }
        return node;
    }

    public static void restoreInitialConfig() {
        TypedProperties config = JPPFConfiguration.getProperties();
        for (Map.Entry entry : initialConfig.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            config.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void setSecurity() throws Exception {
        TypedProperties props;
        String s;
        if (!securityManagerSet && (s = (props = JPPFConfiguration.getProperties()).getString("jppf.policy.file")) != null) {
            if (debugEnabled) {
                log.debug("setting security");
            }
            Policy.setPolicy((Policy)new JPPFPolicy((ClassLoader)NodeRunner.getJPPFClassLoader()));
            System.setSecurityManager(new SecurityManager());
            securityManagerSet = true;
        }
    }

    private static void unsetSecurity() {
        if (securityManagerSet) {
            if (debugEnabled) {
                log.debug("un-setting security");
            }
            PrivilegedAction<Object> pa = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setSecurityManager(null);
                    return null;
                }
            };
            AccessController.doPrivileged(pa);
            securityManagerSet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractJPPFClassLoader getJPPFClassLoader() {
        Class<JPPFClassLoader> clazz = JPPFClassLoader.class;
        synchronized (JPPFClassLoader.class) {
            if (classLoader == null) {
                PrivilegedAction<JPPFClassLoader> pa = new PrivilegedAction<JPPFClassLoader>(){

                    @Override
                    public JPPFClassLoader run() {
                        return new JPPFClassLoader(offline ? null : new RemoteClassLoaderConnection(currentConnectionInfo), NodeRunner.class.getClassLoader());
                    }
                };
                classLoader = AccessController.doPrivileged(pa);
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return classLoader;
        }
    }

    public static void setPersistentData(Object key, Object value) {
        persistentData.put(key, value);
    }

    public static Object getPersistentData(Object key) {
        return persistentData.get(key);
    }

    public static Object removePersistentData(Object key) {
        return persistentData.remove(key);
    }

    public static Node getNode() {
        return node;
    }

    public static void shutdown(NodeInternal node, boolean restart) {
        new ShutdownOrRestart(restart, node).run();
    }

    private static void stopJmxServer() {
        try {
            node.stopJmxServer();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        node.stopJmxServer();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Future<?> f = executor.submit(r);
            try {
                f.get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getUuid() {
        return uuid;
    }

    public static AtomicBoolean getShuttingDown() {
        return shuttingDown;
    }

    public static boolean isOffline() {
        return offline;
    }

    static {
        JPPFInitializer.init();
        log = LoggerFactory.getLogger(NodeRunner.class);
        debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
        classLoader = null;
        securityManagerSet = false;
        persistentData = new Hashtable();
        executor = Executors.newFixedThreadPool(1);
        node = null;
        serviceLock = new SimpleObjectLock();
        uuid = JPPFConfiguration.getProperties().getString("jppf.node.uuid", JPPFUuid.normalUUID());
        offline = JPPFConfiguration.getProperties().getBoolean("jppf.node.offline", false);
        initialConfig = null;
        shuttingDown = new AtomicBoolean(false);
        currentConnectionInfo = null;
        launcherListener = null;
        ANDROID = JPPFConfiguration.getProperties().getBoolean("jppf.node.android", false);
    }

    public static class ShutdownOrRestart
    implements Runnable {
        private boolean restart = false;
        private final NodeInternal node;

        public ShutdownOrRestart(boolean restart, NodeInternal node) {
            this.restart = restart;
            this.node = node;
        }

        @Override
        public void run() {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ShutdownOrRestart.this.node.stopNode();
                    NodeRunner.stopJmxServer();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(ShutdownOrRestart.this.restart ? 2 : 0);
                    return null;
                }
            });
        }
    }
}

