/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.connection;

import java.io.Reader;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jppf.node.connection.ConnectionContext;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.node.connection.DriverConnectionInfo;
import org.jppf.node.connection.DriverConnectionStrategy;
import org.jppf.node.connection.JPPFDefaultConnectionStrategy;
import org.jppf.node.connection.JPPFDriverConnectionInfo;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFCsvFileConnectionStrategy
implements DriverConnectionStrategy {
    private static Logger log = LoggerFactory.getLogger(JPPFCsvFileConnectionStrategy.class);
    private final Queue<DriverConnectionInfo> queue = new LinkedBlockingQueue<DriverConnectionInfo>();
    private final DriverConnectionStrategy fallbackStrategy;

    public JPPFCsvFileConnectionStrategy() {
        this.readCsvFile();
        DriverConnectionStrategy driverConnectionStrategy = this.fallbackStrategy = this.queue.isEmpty() ? new JPPFDefaultConnectionStrategy() : null;
        if (log.isDebugEnabled()) {
            if (this.queue.isEmpty()) {
                log.debug("no valid driver definition found, falling back to default strategy");
            } else {
                StringBuilder sb = new StringBuilder("driver definitions:");
                for (DriverConnectionInfo info : this.queue) {
                    sb.append('\n').append(info);
                }
                log.debug(sb.toString());
            }
        }
    }

    @Override
    public DriverConnectionInfo nextConnectionInfo(DriverConnectionInfo currentInfo, ConnectionContext context) {
        if (this.fallbackStrategy != null) {
            return this.fallbackStrategy.nextConnectionInfo(currentInfo, context);
        }
        if (log.isDebugEnabled()) {
            log.debug("new connection request with prevInfo={} and context={}", (Object)currentInfo, (Object)context);
        }
        if (currentInfo != null && context.getReason() == ConnectionReason.MANAGEMENT_REQUEST) {
            return currentInfo;
        }
        DriverConnectionInfo info = this.queue.poll();
        this.queue.offer(info);
        return info;
    }

    private void readCsvFile() {
        try {
            Reader reader;
            String path = JPPFConfiguration.getProperties().getString("jppf.server.connection.strategy.file");
            if (path != null && !(path = path.trim()).isEmpty() && (reader = FileUtils.getFileReader((String)path)) != null) {
                List lines = FileUtils.textFileAsLines((Reader)reader);
                for (String line : lines) {
                    DriverConnectionInfo info = this.parseLine(line.trim());
                    if (info == null) continue;
                    this.queue.offer(info);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private DriverConnectionInfo parseLine(String csv) {
        if (csv.startsWith("#")) {
            return null;
        }
        String[] tokens = csv.split(",");
        if (tokens != null && tokens.length == 4) {
            int recoveryPort;
            int port;
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = tokens[i].trim();
            }
            boolean secure = "true".equalsIgnoreCase(tokens[0]);
            String host = tokens[1];
            try {
                port = Integer.valueOf(tokens[2]);
            }
            catch (Exception e) {
                return null;
            }
            try {
                recoveryPort = Integer.valueOf(tokens[3]);
            }
            catch (Exception e) {
                recoveryPort = -1;
            }
            return new JPPFDriverConnectionInfo(secure, host, port, recoveryPort);
        }
        return null;
    }
}

