/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.connection;

import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.discovery.JPPFMulticastReceiver;
import org.jppf.node.connection.ConnectionContext;
import org.jppf.node.connection.DriverConnectionInfo;
import org.jppf.node.connection.DriverConnectionStrategy;
import org.jppf.node.connection.JPPFDriverConnectionInfo;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFDefaultConnectionStrategy
implements DriverConnectionStrategy {
    private static Logger log = LoggerFactory.getLogger(JPPFDefaultConnectionStrategy.class);

    @Override
    public DriverConnectionInfo nextConnectionInfo(DriverConnectionInfo currentInfo, ConnectionContext context) {
        return JPPFConfiguration.getProperties().getBoolean("jppf.discovery.enabled", true) ? this.discoverDriver() : this.connectionFromManualConfiguration();
    }

    private DriverConnectionInfo discoverDriver() {
        TypedProperties config = JPPFConfiguration.getProperties();
        JPPFMulticastReceiver receiver = new JPPFMulticastReceiver(new IPFilter(config));
        JPPFConnectionInformation info = receiver.receive();
        receiver.setStopped(true);
        if (info == null) {
            if (log.isDebugEnabled()) {
                log.debug("Could not auto-discover the driver connection information");
            }
            return this.connectionFromManualConfiguration();
        }
        if (log.isDebugEnabled()) {
            log.debug("Discovered driver: " + info);
        }
        boolean ssl = config.getBoolean("jppf.ssl.enabled", false);
        boolean recovery = config.getBoolean("jppf.recovery.enabled", false) && info.recoveryPort >= 0;
        return JPPFDriverConnectionInfo.fromJPPFConnectionInformation(info, ssl, recovery);
    }

    private DriverConnectionInfo connectionFromManualConfiguration() {
        TypedProperties config = JPPFConfiguration.getProperties();
        boolean ssl = config.getBoolean("jppf.ssl.enabled", false);
        String host = config.getString("jppf.server.host", "localhost");
        int port = config.getInt("jppf.server.port", ssl ? 11143 : 11111);
        int recoveryPort = config.getBoolean("jppf.recovery.enabled", false) ? config.getInt("jppf.recovery.server.port", -1) : -1;
        return new JPPFDriverConnectionInfo(ssl, host, port, recoveryPort);
    }
}

