/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.connection;

import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.node.connection.DriverConnectionInfo;

public class JPPFDriverConnectionInfo
implements DriverConnectionInfo {
    protected boolean secure;
    protected String host;
    protected int port;
    protected int recoveryPort;

    public JPPFDriverConnectionInfo() {
        this.secure = false;
        this.host = "localhost";
        this.port = 11111;
        this.recoveryPort = -1;
    }

    public JPPFDriverConnectionInfo(boolean secure, String host, int port, int recoveryPort) {
        this.secure = secure;
        this.host = host;
        this.port = port;
        this.recoveryPort = recoveryPort;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getRecoveryPort() {
        return this.recoveryPort;
    }

    public void setRecoveryPort(int recoveryPort) {
        this.recoveryPort = recoveryPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.recoveryPort;
        result = 31 * result + (this.secure ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JPPFDriverConnectionInfo other = (JPPFDriverConnectionInfo)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.recoveryPort != other.recoveryPort) {
            return false;
        }
        return this.secure == other.secure;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("secure=").append(this.secure);
        sb.append(", host=").append(this.host);
        sb.append(", port=").append(this.port);
        sb.append(", recoveryPort=").append(this.recoveryPort);
        sb.append(']');
        return sb.toString();
    }

    public static DriverConnectionInfo fromJPPFConnectionInformation(JPPFConnectionInformation ci, boolean ssl, boolean recovery) {
        int port = ssl ? ci.sslServerPorts[0] : ci.serverPorts[0];
        boolean recoveryEnabled = recovery && ci.recoveryPort >= 0;
        return new JPPFDriverConnectionInfo(ssl, ci.host, port, recoveryEnabled ? ci.recoveryPort : -1);
    }
}

