/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jppf.node.event.LifeCycleEventHandler;
import org.jppf.node.event.NodeLifeCycleErrorHandler;
import org.jppf.node.event.NodeLifeCycleEvent;
import org.jppf.node.event.NodeLifeCycleEventType;
import org.jppf.node.event.NodeLifeCycleListener;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifeCycleErrorHandler
implements NodeLifeCycleErrorHandler {
    private static Logger log = LoggerFactory.getLogger(LifeCycleEventHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    protected static final boolean propagateErrors = JPPFConfiguration.getProperties().getBoolean("jppf.node.listener.errors.propagate", true);
    public static final Map<NodeLifeCycleEventType, String> methodsNamesMap = DefaultLifeCycleErrorHandler.generateMethodsNamesMap();

    @Override
    public void handleError(NodeLifeCycleListener listener, NodeLifeCycleEvent event, Throwable t) {
        String s = StringUtils.build((Object[])new Object[]{"error executing ", methodsNamesMap.get((Object)event.getType()), " on an instance of ", listener.getClass(), ", event=", event, ", listener=", listener, " : "});
        if (debugEnabled) {
            log.debug(s, t);
        } else {
            log.error(s + ExceptionUtils.getMessage((Throwable)t));
        }
        if (propagateErrors && t instanceof Error) {
            throw (Error)t;
        }
    }

    private static Map<NodeLifeCycleEventType, String> generateMethodsNamesMap() {
        HashMap<NodeLifeCycleEventType, String> map = new HashMap<NodeLifeCycleEventType, String>();
        map.put(NodeLifeCycleEventType.NODE_STARTING, "nodeStarting()");
        map.put(NodeLifeCycleEventType.NODE_ENDING, "nodeEnding()");
        map.put(NodeLifeCycleEventType.JOB_HEADER_LOADED, "jobHeaderLoaded()");
        map.put(NodeLifeCycleEventType.JOB_STARTING, "jobStarting()");
        map.put(NodeLifeCycleEventType.JOB_ENDING, "jobEnding()");
        map.put(NodeLifeCycleEventType.BEFORE_NEXT_JOB, "beforeNextJob()");
        return Collections.unmodifiableMap(map);
    }
}

