/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.event;

import java.io.File;
import java.net.URL;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.location.FileLocation;
import org.jppf.location.Location;
import org.jppf.location.MemoryLocation;
import org.jppf.location.URLLocation;
import org.jppf.node.Node;
import org.jppf.node.event.NodeLifeCycleEvent;
import org.jppf.node.event.NodeLifeCycleListenerAdapter;
import org.jppf.node.protocol.ClassPath;
import org.jppf.node.protocol.ClassPathElement;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFDefaultUncaughtExceptionHandler;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClassPathHandler
extends NodeLifeCycleListenerAdapter {
    private static final Logger log = LoggerFactory.getLogger(JobClassPathHandler.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    @Override
    public void jobHeaderLoaded(NodeLifeCycleEvent event) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JPPFDefaultUncaughtExceptionHandler());
        Node node = event.getNode();
        if (!node.isOffline()) {
            return;
        }
        ClassPath classpath = event.getJob().getSLA().getClassPath();
        if (!node.isAndroid()) {
            if (log.isTraceEnabled()) {
                log.trace(StringUtils.printClassLoaderHierarchy((ClassLoader)event.getTaskClassLoader()));
            }
            AbstractJPPFClassLoader cl = event.getTaskClassLoader();
            if (classpath != null && (classpath.isForceClassLoaderReset() || !classpath.isEmpty())) {
                cl = node.resetTaskClassLoader(new Object[0]);
            }
            if (classpath != null && !classpath.isEmpty()) {
                for (ClassPathElement elt : classpath) {
                    boolean validated = false;
                    try {
                        validated = elt.validate();
                    }
                    catch (Throwable t) {
                        String format = "exception occurred during validation of classpath element '{}' : {}";
                        if (debugEnabled) {
                            log.debug(format, (Object)elt, (Object)ExceptionUtils.getStackTrace((Throwable)t));
                        }
                        log.warn(format, (Object)elt, (Object)ExceptionUtils.getMessage((Throwable)t));
                    }
                    if (!validated) continue;
                    URL url = null;
                    Location local = elt.getLocalLocation();
                    Location remote = elt.getRemoteLocation();
                    try {
                        if (remote != local) {
                            local.copyTo(remote);
                        }
                        if (remote instanceof MemoryLocation) {
                            cl.getResourceCache().registerResource(elt.getName(), remote);
                            url = cl.getResourceCache().getResourceURL(elt.getName());
                        } else if (remote instanceof FileLocation) {
                            File file = new File((String)((FileLocation)remote).getPath());
                            if (file.exists()) {
                                url = file.toURI().toURL();
                            }
                        } else if (remote instanceof URLLocation) {
                            url = (URL)((URLLocation)remote).getPath();
                        }
                    }
                    catch (Exception e) {
                        String format = "exception occurred during processing of classpath element '{}' : {}";
                        if (debugEnabled) {
                            log.debug(format, (Object)elt, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                        }
                        log.warn(format, (Object)elt, (Object)ExceptionUtils.getMessage((Throwable)e));
                    }
                    if (url == null) continue;
                    cl.addURL(url);
                }
                classpath.clear();
            }
        }
    }
}

