/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.event;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.node.Node;
import org.jppf.node.event.DefaultLifeCycleErrorHandler;
import org.jppf.node.event.NodeLifeCycleErrorHandler;
import org.jppf.node.event.NodeLifeCycleEvent;
import org.jppf.node.event.NodeLifeCycleEventType;
import org.jppf.node.event.NodeLifeCycleListener;
import org.jppf.node.protocol.DataProvider;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.Task;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ServiceFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleEventHandler {
    private static Logger log = LoggerFactory.getLogger(LifeCycleEventHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final NodeLifeCycleErrorHandler DEFAULT_ERROR_HANDLER = new DefaultLifeCycleErrorHandler();
    private final List<NodeLifeCycleListener> listeners = new CopyOnWriteArrayList<NodeLifeCycleListener>();
    private final Node node;

    public LifeCycleEventHandler(Node node) {
        this.node = node;
    }

    public void addNodeLifeCycleListener(NodeLifeCycleListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeNodeLifeCycleListener(NodeLifeCycleListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void fireNodeStarting() {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(this.node, NodeLifeCycleEventType.NODE_STARTING);
        for (NodeLifeCycleListener listener : this.listeners) {
            try {
                listener.nodeStarting(event);
            }
            catch (Throwable t) {
                this.handleError(listener, event, t);
            }
        }
    }

    public void fireNodeEnding() {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(this.node, NodeLifeCycleEventType.NODE_ENDING);
        for (NodeLifeCycleListener listener : this.listeners) {
            try {
                listener.nodeEnding(event);
            }
            catch (Throwable t) {
                this.handleError(listener, event, t);
            }
        }
    }

    public void fireJobHeaderLoaded(JPPFDistributedJob job, AbstractJPPFClassLoader cl) {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(this.node, NodeLifeCycleEventType.JOB_HEADER_LOADED, job, cl);
        for (NodeLifeCycleListener listener : this.listeners) {
            try {
                listener.jobHeaderLoaded(event);
            }
            catch (Throwable t) {
                this.handleError(listener, event, t);
            }
        }
    }

    public void fireJobStarting(JPPFDistributedJob job, AbstractJPPFClassLoader cl, List<Task<?>> tasks, DataProvider dataProvider) {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(this.node, NodeLifeCycleEventType.JOB_STARTING, job, cl, tasks, dataProvider);
        for (NodeLifeCycleListener listener : this.listeners) {
            try {
                listener.jobStarting(event);
            }
            catch (Throwable t) {
                this.handleError(listener, event, t);
            }
        }
    }

    public void fireJobEnding(JPPFDistributedJob job, AbstractJPPFClassLoader cl, List<Task<?>> tasks, DataProvider dataProvider) {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(this.node, NodeLifeCycleEventType.JOB_ENDING, job, cl, tasks, dataProvider);
        for (NodeLifeCycleListener listener : this.listeners) {
            try {
                listener.jobEnding(event);
            }
            catch (Throwable t) {
                this.handleError(listener, event, t);
            }
        }
    }

    public void fireBeforeNextJob() {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(this.node, NodeLifeCycleEventType.BEFORE_NEXT_JOB, null, null, null, null);
        for (NodeLifeCycleListener listener : this.listeners) {
            try {
                listener.beforeNextJob(event);
            }
            catch (Throwable t) {
                this.handleError(listener, event, t);
            }
        }
    }

    public void loadListeners() {
        Iterator it = ServiceFinder.lookupProviders(NodeLifeCycleListener.class);
        while (it.hasNext()) {
            try {
                NodeLifeCycleListener listener = (NodeLifeCycleListener)it.next();
                this.addNodeLifeCycleListener(listener);
                if (!debugEnabled) continue;
                log.debug("successfully added node life cycle listener " + listener.getClass().getName());
            }
            catch (Error e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleError(NodeLifeCycleListener listener, NodeLifeCycleEvent event, Throwable t) {
        NodeLifeCycleErrorHandler handler = listener instanceof NodeLifeCycleErrorHandler ? (NodeLifeCycleErrorHandler)((Object)listener) : DEFAULT_ERROR_HANDLER;
        try {
            handler.handleError(listener, event, t);
        }
        catch (Exception e) {
            String msg = "exception occurred while invoking error handler " + handler + " :\n" + ExceptionUtils.getStackTrace((Throwable)e);
            log.error(msg);
        }
    }
}

