/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.initialization;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.jppf.node.initialization.InitializationHook;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.UnmodifiableTypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputRedirectHook
implements InitializationHook {
    private static Logger log = LoggerFactory.getLogger(OutputRedirectHook.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    @Override
    public void initializing(UnmodifiableTypedProperties config) {
        this.handleStream(config, true);
        this.handleStream(config, false);
    }

    private void handleStream(UnmodifiableTypedProperties config, boolean isOut) {
        try {
            String propBase = "jppf.redirect." + (isOut ? "out" : "err");
            File outFile = config.getFile(propBase);
            if (outFile == null) {
                return;
            }
            boolean append = config.getBoolean(propBase + ".append", false);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile, append));
            if (os != null) {
                PrintStream pos = new PrintStream(os, true);
                pos.println("********** " + new Date() + " **********");
                if (isOut) {
                    System.setOut(pos);
                } else {
                    System.setErr(pos);
                }
            }
        }
        catch (Exception e) {
            String message = "error occurred while trying to redirect System." + (isOut ? "out" : "err") + " : {}";
            if (debugEnabled) {
                log.debug(message, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            log.warn(message, (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }
}

