/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.provisioning;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.io.FileUtils;
import org.jppf.node.NodeRunner;
import org.jppf.node.provisioning.SlaveNodeLauncher;
import org.jppf.process.ProcessLauncherEvent;
import org.jppf.process.ProcessLauncherListener;
import org.jppf.utils.ConcurrentUtils;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFThreadFactory;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SlaveNodeManager
implements ProcessLauncherListener {
    private static Logger log = LoggerFactory.getLogger(SlaveNodeManager.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final String SLAVE_PATH_PREFIX = JPPFConfiguration.getProperties().getString("jppf.node.provisioning.slave.path.prefix", "slave_nodes/node_");
    private static final String SLAVE_CONFIG_PATH = JPPFConfiguration.getProperties().getString("jppf.node.provisioning.slave.config.path", "config");
    static final String SLAVE_LOCAL_CONFIG_DIR = "config";
    static final String SLAVE_LOCAL_CONFIG_FILE = "jppf-node.properties";
    static final long REQUEST_CHECK_TIMEOUT = JPPFConfiguration.getProperties().getLong("jppf.provisioning.request.check.timeout", 15000L);
    static final SlaveNodeManager INSTANCE = new SlaveNodeManager();
    private final TreeMap<Integer, SlaveNodeLauncher> slaves = new TreeMap();
    private Set<Integer> reservedIds = new HashSet<Integer>();
    private final File masterDir;
    private final List<String> slaveClasspath = new ArrayList<String>();
    private TypedProperties configOverrides = new TypedProperties();
    private ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new JPPFThreadFactory("SlaveNodeManager"));

    private SlaveNodeManager() {
        this.masterDir = new File(System.getProperty("user.dir"));
        if (debugEnabled) {
            log.debug("masterDir = {}, request check timeout = {} ms", (Object)this.masterDir, (Object)REQUEST_CHECK_TIMEOUT);
        }
        this.computeSlaveClasspath();
    }

    void submitProvisioningRequest(final int requestedSlaves, final boolean interruptIfRunning, final TypedProperties configOverrides) {
        if (requestedSlaves < 0) {
            return;
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                SlaveNodeManager.this.shrinkOrGrowSlaves(requestedSlaves, interruptIfRunning, configOverrides);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shrinkOrGrowSlaves(final int requestedSlaves, boolean interruptIfRunning, TypedProperties configOverrides) {
        int i;
        int action;
        if (debugEnabled) {
            log.debug(String.format("provisioning request for %d slaves, interruptIfRunning=%b, configOverrides=%s", requestedSlaves, interruptIfRunning, configOverrides));
        }
        int n = action = interruptIfRunning ? 3 : 4;
        if (configOverrides != null) {
            if (debugEnabled) {
                log.debug("stopping all processes");
            }
            this.configOverrides = configOverrides;
            TreeMap<Integer, SlaveNodeLauncher> treeMap = this.slaves;
            synchronized (treeMap) {
                Iterator<SlaveNodeLauncher> i$ = this.slaves.values().iterator();
                while (i$.hasNext()) {
                    SlaveNodeLauncher slave;
                    SlaveNodeLauncher slaveNodeLauncher = slave = i$.next();
                    synchronized (slaveNodeLauncher) {
                        if (slave.isStarted()) {
                            slave.sendActionCommand(action);
                        } else {
                            slave.setStopped(true);
                            this.removeSlave(slave);
                        }
                    }
                }
            }
        }
        int size = this.nbSlaves();
        int diff = size - requestedSlaves;
        int id = -1;
        if (diff > 0) {
            log.debug("stopping " + diff + " processes");
            for (i = requestedSlaves; i < size; ++i) {
                SlaveNodeLauncher slave = null;
                Object object = this.slaves;
                synchronized (object) {
                    id = id < 0 ? this.slaves.lastKey() : this.slaves.lowerKey(id);
                    slave = this.slaves.get(id);
                }
                log.debug("stopping {}", (Object)slave.getName());
                object = slave;
                synchronized (object) {
                    if (slave.isStarted()) {
                        slave.sendActionCommand(action);
                    } else {
                        slave.setStopped(true);
                        this.removeSlave(slave);
                    }
                    continue;
                }
            }
        } else {
            if (debugEnabled) {
                log.debug("starting " + -diff + " processes");
            }
            for (i = size; i < requestedSlaves; ++i) {
                id = this.reserveNextAvailableId();
                String slaveDirPath = SLAVE_PATH_PREFIX + id;
                try {
                    log.debug("starting slave at {}", (Object)slaveDirPath);
                    this.setupSlaveNodeFiles(slaveDirPath, this.configOverrides, id);
                    SlaveNodeLauncher slave = new SlaveNodeLauncher(id, slaveDirPath, this.slaveClasspath);
                    slave.addProcessLauncherListener(this);
                    new Thread((Runnable)((Object)slave), slaveDirPath).start();
                    continue;
                }
                catch (Error | Exception e) {
                    log.error("error trying to start '{}' : {}", (Object)slaveDirPath, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    if (!(e instanceof Error)) continue;
                    throw (Error)e;
                }
            }
        }
        if (REQUEST_CHECK_TIMEOUT > 0L) {
            long start = System.nanoTime();
            boolean check = ConcurrentUtils.awaitCondition((ConcurrentUtils.Condition)new ConcurrentUtils.Condition(){

                public boolean evaluate() {
                    return SlaveNodeManager.this.nbSlaves() == requestedSlaves;
                }
            }, (long)REQUEST_CHECK_TIMEOUT);
            long elapsed = (System.nanoTime() - start) / 1000000L;
            if (debugEnabled) {
                log.debug(String.format("fullfilment check for provisioning request for %d slaves %s after %,d ms", requestedSlaves, check ? "succeeded" : "timed out", elapsed));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nbSlaves() {
        TreeMap<Integer, SlaveNodeLauncher> treeMap = this.slaves;
        synchronized (treeMap) {
            return this.slaves.size();
        }
    }

    private void setupSlaveNodeFiles(String slaveDirPath, TypedProperties configOverrides, int id) throws Exception {
        File slaveDir = new File(slaveDirPath);
        if (!slaveDir.exists()) {
            slaveDir.mkdirs();
        }
        File slaveConfigSrc = new File(SLAVE_CONFIG_PATH);
        File slaveConfigDest = new File(slaveDir, SLAVE_LOCAL_CONFIG_DIR);
        if (!slaveConfigDest.exists()) {
            slaveConfigDest.mkdirs();
        }
        if (slaveConfigSrc.exists()) {
            FileUtils.copyDirectory((File)slaveConfigSrc, (File)slaveConfigDest);
            if (debugEnabled) {
                log.debug("copied files from {} to {}", (Object)slaveConfigSrc, (Object)slaveConfigDest);
            }
        } else if (debugEnabled) {
            log.debug("config source dir '{}' does not exist", (Object)slaveConfigSrc);
        }
        TypedProperties config = JPPFConfiguration.getProperties();
        TypedProperties props = new TypedProperties((Map)config);
        for (String key : configOverrides.stringPropertyNames()) {
            props.setProperty(key, configOverrides.getProperty(key));
        }
        props.setBoolean("jppf.node.provisioning.master", false);
        props.setBoolean("jppf.node.provisioning.slave", true);
        props.setInt("jppf.node.provisioning.slave.id", id);
        props.setString("jppf.node.provisioning.master.uuid", NodeRunner.getUuid());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(slaveConfigDest, SLAVE_LOCAL_CONFIG_FILE)));){
            props.store((Writer)writer, "generated jppf configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStarted(ProcessLauncherEvent event) {
        SlaveNodeLauncher slave = (SlaveNodeLauncher)event.getProcessLauncher();
        TreeMap<Integer, SlaveNodeLauncher> treeMap = this.slaves;
        synchronized (treeMap) {
            this.slaves.put(slave.getId(), slave);
        }
        if (this.nbSlaves() <= 0) {
            log.warn("received processStarted() for slave id = {}, but nbSlaves is zero", (Object)slave.getId());
        } else if (debugEnabled) {
            log.debug("received processStarted() for slave id = {}", (Object)slave.getId());
        }
    }

    public void processStopped(ProcessLauncherEvent event) {
        SlaveNodeLauncher slave = (SlaveNodeLauncher)event.getProcessLauncher();
        if (debugEnabled) {
            log.debug("received processStopped() for slave id = {}, exitCode = {}", (Object)slave.getId(), (Object)slave.exitCode);
        }
        if (slave.exitCode != 2) {
            this.removeSlave(slave);
        } else {
            new Thread((Runnable)((Object)slave), slave.getName()).start();
        }
    }

    private void computeSlaveClasspath() {
        String[] paths;
        String separator = System.getProperty("path.separator");
        String cp = System.getProperty("java.class.path");
        for (String path : paths = cp.split(separator)) {
            if (path == null) continue;
            this.slaveClasspath.add(new File(path).getAbsolutePath());
        }
        this.slaveClasspath.add(".");
        this.slaveClasspath.add(SLAVE_LOCAL_CONFIG_DIR);
    }

    public static void handleStartup() {
        int n = JPPFConfiguration.getProperties().getInt("jppf.node.provisioning.startup.slaves", 0);
        if (n > 0) {
            String msg = "starting " + n + " slave nodes";
            log.info(msg);
            System.out.println(msg);
            INSTANCE.shrinkOrGrowSlaves(n, true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextAvailableId() {
        int count = 0;
        Set<Integer> set = this.reservedIds;
        synchronized (set) {
            while (this.reservedIds.contains(count)) {
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reserveNextAvailableId() {
        int count = this.nextAvailableId();
        Set<Integer> set = this.reservedIds;
        synchronized (set) {
            this.reservedIds.add(count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSlave(SlaveNodeLauncher slave) {
        Object object = this.slaves;
        synchronized (object) {
            this.slaves.remove(slave.getId());
        }
        object = this.reservedIds;
        synchronized (object) {
            this.reservedIds.remove(slave.getId());
        }
    }
}

