/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.screensaver;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.jppf.node.initialization.InitializationHook;
import org.jppf.node.screensaver.FocusedJFrame;
import org.jppf.node.screensaver.JPPFScreenSaver;
import org.jppf.node.screensaver.impl.JPPFScreenSaverImpl;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFDefaultUncaughtExceptionHandler;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.UnmodifiableTypedProperties;

public class ScreenSaverMain
implements InitializationHook {
    private static ScreenSaverMain instance = null;
    private TypedProperties config;
    private JPPFScreenSaver screensaver = null;

    public static void main(String[] args) {
        try {
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JPPFDefaultUncaughtExceptionHandler());
            new ScreenSaverMain().startScreenSaver(JPPFConfiguration.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initializing(UnmodifiableTypedProperties initialConfiguration) {
        try {
            if (instance != null) {
                return;
            }
            if (initialConfiguration.getBoolean("jppf.screensaver.enabled")) {
                this.startScreenSaver((TypedProperties)initialConfiguration);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startScreenSaver(TypedProperties config) throws Exception {
        instance = this;
        this.config = config;
        this.createUI();
    }

    private void createUI() throws Exception {
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("This is a headless graphics environment - cannot run in full screen");
            return;
        }
        boolean fullscreenRequested = this.config.getBoolean("jppf.screensaver.fullscreen", false);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsDevice[] devices = env.getScreenDevices();
        boolean fullscreenSupported = true;
        Rectangle2D.Double result = new Rectangle2D.Double();
        for (GraphicsDevice gd : devices) {
            fullscreenSupported &= gd.isFullScreenSupported();
            for (GraphicsConfiguration graphicsConfiguration : gd.getConfigurations()) {
                Rectangle2D.union(result, graphicsConfiguration.getBounds(), result);
            }
        }
        if (fullscreenRequested && !fullscreenSupported) {
            System.err.println("Full screen is not supported by the current graphics device");
        }
        String title = this.config.getString("jppf.screensaver.title", "JPPF screensaver");
        final FocusedJFrame frame = new FocusedJFrame(title);
        ImageIcon icon = ScreenSaverMain.loadImage(this.config.getString("jppf.screensaver.icon", "org/jppf/node/jppf-icon.gif"));
        if (icon == null) {
            icon = ScreenSaverMain.loadImage("org/jppf/node/jppf-icon.gif");
        }
        frame.setIconImage(icon.getImage());
        if (fullscreenRequested && fullscreenSupported) {
            frame.setUndecorated(true);
            frame.setSize((int)((RectangularShape)result).getWidth(), (int)((RectangularShape)result).getHeight());
            frame.setResizable(false);
            BufferedImage cursorImg = new BufferedImage(16, 16, 2);
            Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "blank cursor");
            frame.getContentPane().setCursor(blankCursor);
        } else {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            int w = JPPFConfiguration.getProperties().getInt("jppf.screensaver.width", 1000);
            int h = JPPFConfiguration.getProperties().getInt("jppf.screensaver.height", 800);
            if (w <= 0 || w > d.width) {
                w = 1000;
            }
            if (h <= 0 || h > d.height) {
                h = 800;
            }
            frame.setSize(w, h);
        }
        this.configureFrameListeners(frame, fullscreenRequested && fullscreenSupported);
        frame.setBackground(Color.BLACK);
        frame.getContentPane().setBackground(Color.BLACK);
        this.createScreenSaver();
        frame.add(this.screensaver.getComponent());
        this.screensaver.getComponent().setSize(frame.getSize());
        int screenX = this.config.getInt("jppf.screensaver.screen.location.x", 0);
        int screenY = this.config.getInt("jppf.screensaver.screen.location.Y", 0);
        frame.setLocation(screenX, screenY);
        this.screensaver.init(this.config, fullscreenRequested && fullscreenSupported);
        ((Window)frame).setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.toFront();
            }
        });
    }

    private JPPFScreenSaver createScreenSaver() throws Exception {
        try {
            String name = JPPFConfiguration.getProperties().getString("jppf.screensaver.class", "org.jppf.node.screensaver.impl.JPPFScreenSaverImpl");
            Class<?> clazz = Class.forName(name);
            this.screensaver = (JPPFScreenSaver)clazz.newInstance();
        }
        catch (Exception e) {
            this.screensaver = new JPPFScreenSaverImpl();
        }
        return this.screensaver;
    }

    private void configureFrameListeners(JFrame frame, boolean fullscreen) {
        if (fullscreen) {
            frame.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    ScreenSaverMain.this.doOnclose();
                }
            });
            frame.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ScreenSaverMain.this.doOnclose();
                }
            });
            if (this.config.getBoolean("jppf.screensaver.mouse.motion.close", true)) {
                final long mouseMotionDelay = this.config.getLong("jppf.screensaver.mouse.motion.delay", 500L);
                final long start = System.currentTimeMillis();
                frame.addMouseMotionListener(new MouseAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (System.currentTimeMillis() - start > mouseMotionDelay) {
                            ScreenSaverMain.this.doOnclose();
                        }
                    }
                });
            }
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ScreenSaverMain.this.doOnclose();
            }
        });
    }

    JPPFScreenSaver getScreenSaver() {
        return this.screensaver;
    }

    static ScreenSaverMain getInstance() {
        return instance;
    }

    TypedProperties getConfig() {
        return this.config;
    }

    private void doOnclose() {
        if (this.screensaver != null) {
            this.screensaver.destroy();
        }
        System.exit(0);
    }

    public static ImageIcon loadImage(String file) {
        byte[] buf = null;
        try {
            buf = FileUtils.getPathAsByte((String)file);
        }
        catch (Exception e) {
            System.err.println("Could not load image '" + file + "' : " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return buf == null ? null : new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
    }
}

