/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.screensaver.impl;

import java.awt.Dimension;
import java.awt.Image;
import java.util.Random;
import javax.swing.ImageIcon;

class ImageData {
    public int prevx = 0;
    public int prevy = 0;
    public int x = 0;
    public int y = 0;
    public int stepx = 1;
    public int stepy = 1;
    public final int imgw;
    public final int imgh;
    public Image img;
    private Random rand = new Random(System.nanoTime());

    public ImageData(ImageIcon logoIcon) {
        this.img = logoIcon.getImage();
        this.imgw = logoIcon.getIconWidth();
        this.imgh = logoIcon.getIconHeight();
    }

    public void init(Dimension dim) {
        int n = dim.width - this.imgw;
        if (n <= 0) {
            n = this.imgw;
        }
        this.prevx = this.x = this.rand.nextInt(n);
        this.stepx = this.randomValueInRange(-2, 2);
        n = dim.height - this.imgh;
        if (n <= 0) {
            n = this.imgh;
        }
        this.prevy = this.y = this.rand.nextInt(n);
        this.stepy = this.randomValueInRange(-2, 2);
    }

    private boolean checkColliding(ImageData d) {
        int x1 = this.x + this.stepx;
        int y1 = this.y + this.stepy;
        if (this.isIn(x1, y1, d)) {
            if (this.x >= d.x + d.imgw) {
                this.reverseX(d);
            }
            if (this.y >= d.y + d.imgh) {
                this.reverseY(d);
            }
            return true;
        }
        if (this.isIn(x1 + this.imgw, y1, d)) {
            if (this.x <= d.x - d.imgw) {
                this.reverseX(d);
            }
            if (this.y >= d.y + d.imgh) {
                this.reverseY(d);
            }
            return true;
        }
        if (this.isIn(x1, y1 + this.imgh, d)) {
            if (this.x >= d.x + d.imgw) {
                this.reverseX(d);
            }
            if (this.y <= d.y - d.imgh) {
                this.reverseY(d);
            }
            return true;
        }
        if (this.isIn(x1 + this.imgw, y1 + this.imgh, d)) {
            if (this.x <= d.x - d.imgw) {
                this.reverseX(d);
            }
            if (this.y <= d.y - d.imgh) {
                this.reverseY(d);
            }
            return true;
        }
        return false;
    }

    private void reverseX(ImageData d) {
        this.stepx = -this.stepx;
        d.stepx = -d.stepx;
    }

    private void reverseY(ImageData d) {
        this.stepy = -this.stepy;
        d.stepy = -d.stepy;
    }

    public synchronized void update(Dimension screenDimension, ImageData[] data, int startIndex) {
        if (data != null) {
            for (int i = startIndex; i < data.length; ++i) {
                this.checkColliding(data[i]);
            }
        }
        if (this.x + this.stepx < 0 || this.x + this.stepx + this.imgw > screenDimension.width) {
            this.stepx = -this.stepx;
        }
        if (this.y + this.stepy < 0 || this.y + this.stepy + this.imgh > screenDimension.height) {
            this.stepy = -this.stepy;
        }
        this.x += this.stepx;
        this.y += this.stepy;
        int r = this.rand.nextInt(100);
        if (r == 0) {
            int s = this.stepx < 0 ? -1 : 1;
            this.stepx = s * this.randomValueInRange(1, 2);
            s = this.stepy < 0 ? -1 : 1;
            this.stepy = s * this.randomValueInRange(1, 2);
        }
    }

    private boolean isIn(int x1, int y1, ImageData d) {
        int x2 = d.x + d.stepx;
        int y2 = d.y + d.stepy;
        return x1 >= x2 && x1 <= x2 + d.imgw && y1 >= y2 && y1 <= y2 + d.imgh;
    }

    private int randomValueInRange(int min, int max) {
        int result = 0;
        while (result == 0) {
            int diff = max - min;
            result = min + this.rand.nextInt(diff + 1);
        }
        return result;
    }
}

