/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.screensaver.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jppf.node.screensaver.ScreenSaverMain;
import org.jppf.utils.JPPFConfiguration;

public class NodePanel
extends JPanel {
    public static final String IMAGE_PATH = "org/jppf/node";
    static final ImageIcon BRIGHT_GREEN = ScreenSaverMain.loadImage("org/jppf/node/active_greenlight.gif");
    static final ImageIcon DARK_RED = ScreenSaverMain.loadImage("org/jppf/node/inactive_redlight.gif");
    static final String DEFAULT_IMG = "org/jppf/node/jppf@home.gif";
    private long taskCount = 0L;
    private JLabel[] statusLabels = new JLabel[2];
    private JLabel countLabel;
    private JLabel timeLabel;
    private long startedAt = 0L;
    private NumberFormat nf = null;
    private static NumberFormat integerFormatter = null;

    public NodePanel() {
        super(true);
        this.createUI();
    }

    private void createUI() {
        this.initNodeState();
        GridBagLayout g = new GridBagLayout();
        this.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        this.setBackground(Color.BLACK);
        this.addLayoutComp(this, g, c, this.createTopPanel());
        this.addLayoutComp(this, g, c, Box.createVerticalStrut(10));
        this.addLayoutComp(this, g, c, this.createNodePanel());
        this.addLayoutComp(this, g, c, Box.createVerticalStrut(5));
    }

    protected JComponent createTopPanel() {
        String path = JPPFConfiguration.getProperties().getString("jppf.screensaver.centerimage", DEFAULT_IMG);
        ImageIcon logo = ScreenSaverMain.loadImage(path);
        if (logo == null) {
            logo = ScreenSaverMain.loadImage(DEFAULT_IMG);
        }
        return new JLabel(logo);
    }

    private void initNodeState() {
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setGroupingUsed(true);
        this.nf.setMaximumFractionDigits(0);
        this.nf.setMinimumIntegerDigits(1);
        this.startedAt = System.currentTimeMillis();
        for (int i = 0; i < this.statusLabels.length; ++i) {
            this.statusLabels[i] = new JLabel(DARK_RED);
        }
        Dimension d = new Dimension(8, 8);
        for (JLabel aStatusLabel : this.statusLabels) {
            aStatusLabel.setMinimumSize(d);
            aStatusLabel.setMaximumSize(d);
            aStatusLabel.setBackground(Color.BLACK);
        }
        this.countLabel = new JLabel(Long.toString(this.taskCount));
        d = new Dimension(60, 20);
        this.countLabel.setMinimumSize(d);
        this.countLabel.setMaximumSize(d);
        this.countLabel.setBackground(Color.BLACK);
        this.countLabel.setForeground(Color.WHITE);
        this.timeLabel = new JLabel("Active for: " + NodePanel.toStringDuration(0L));
        this.timeLabel.setBackground(Color.BLACK);
        this.timeLabel.setForeground(Color.WHITE);
    }

    private JPanel createNodePanel() {
        JPanel panel = new JPanel();
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        panel.setLayout(g);
        panel.setBackground(Color.BLACK);
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(25));
        JLabel label = new JLabel("JPPF Node");
        label.setBackground(Color.BLACK);
        label.setForeground(Color.WHITE);
        this.addLayoutComp(panel, g, c, label);
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(50));
        this.addLayoutComp(panel, g, c, this.timeLabel);
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(25));
        this.addLayoutComp(panel, g, c, this.makeStatusPanel(0, "connection"));
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(15));
        this.addLayoutComp(panel, g, c, this.makeStatusPanel(1, "execution"));
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(15));
        label = new JLabel("tasks");
        label.setBackground(Color.BLACK);
        label.setForeground(Color.WHITE);
        this.addLayoutComp(panel, g, c, label);
        panel.add(Box.createHorizontalStrut(5));
        this.countLabel.setPreferredSize(new Dimension(60, 20));
        this.addLayoutComp(panel, g, c, this.countLabel);
        return panel;
    }

    protected void addLayoutComp(JPanel panel, GridBagLayout g, GridBagConstraints c, Component comp) {
        g.setConstraints(comp, c);
        panel.add(comp);
    }

    private JPanel makeStatusPanel(int statusIdx, String text) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(Color.BLACK);
        JLabel label = new JLabel(text);
        label.setBackground(Color.BLACK);
        label.setForeground(Color.WHITE);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(label);
        labelPanel.setBackground(Color.BLACK);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        statusPanel.setBackground(Color.BLACK);
        statusPanel.add(this.statusLabels[statusIdx]);
        labelPanel.setPreferredSize(new Dimension(65, 20));
        panel.add(labelPanel);
        panel.add(Box.createHorizontalStrut(5));
        statusPanel.setPreferredSize(new Dimension(8, 20));
        panel.add(statusPanel);
        panel.setPreferredSize(new Dimension(78, 20));
        return panel;
    }

    public synchronized void updateConnectionStatus(boolean ok) {
        this.statusLabels[0].setIcon(ok ? BRIGHT_GREEN : DARK_RED);
    }

    public synchronized void updateExecutionStatus(boolean ok) {
        this.statusLabels[1].setIcon(ok ? BRIGHT_GREEN : DARK_RED);
    }

    public synchronized void updateTimeLabel() {
        String s = NodePanel.toStringDuration(System.currentTimeMillis() - this.startedAt);
        this.timeLabel.setText("Active for: " + s);
    }

    public synchronized long incTaskCount(long increment) {
        this.taskCount += increment;
        this.countLabel.setText(this.nf.format(this.taskCount));
        return this.taskCount;
    }

    public static String toStringDuration(long duration) {
        if (integerFormatter == null) {
            integerFormatter = NumberFormat.getInstance();
            integerFormatter.setGroupingUsed(false);
            integerFormatter.setMaximumFractionDigits(0);
            integerFormatter.setMinimumIntegerDigits(2);
        }
        long elapsed = duration;
        StringBuilder sb = new StringBuilder();
        sb.append(integerFormatter.format(elapsed / 3600000L)).append(" hrs ");
        sb.append(integerFormatter.format((elapsed %= 3600000L) / 60000L)).append(" mn ");
        sb.append(integerFormatter.format((elapsed %= 60000L) / 1000L)).append(" sec");
        return sb.toString();
    }
}

