/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.screensaver.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jppf.node.screensaver.JPPFScreenSaver;
import org.jppf.utils.TypedProperties;

public class SimpleScreenSaver
extends JPanel
implements JPPFScreenSaver {
    private Random rand = new Random(System.nanoTime());
    private Timer timer = null;
    private volatile boolean reset = false;

    public SimpleScreenSaver() {
        super(true);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void init(TypedProperties config, boolean fullscreen) {
        this.setBackground(Color.BLACK);
        this.timer = new Timer("JPPFScreenSaverTimer");
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SimpleScreenSaver.this.repaint();
            }
        }, 40L, 40L);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SimpleScreenSaver.this.reset = true;
            }
        }, 5000L, 5000L);
    }

    @Override
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.reset) {
            this.reset = false;
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, w, h);
        } else {
            int n = 5;
            for (int i = 0; i < 500; ++i) {
                int x = this.rand.nextInt(w - (n - 1));
                int y = this.rand.nextInt(h - (n - 1));
                g.setColor(new Color(this.rand.nextInt(256), this.rand.nextInt(256), this.rand.nextInt(256)));
                g.fillOval(x, y, n, n);
            }
        }
    }
}

