/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.management.JMXServer;
import org.jppf.node.AbstractNode;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.node.AbstractClassLoaderManager;
import org.jppf.server.node.JPPFContainer;
import org.jppf.server.node.JPPFNode;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommonNode
extends AbstractNode {
    private static Logger log = LoggerFactory.getLogger(JPPFNode.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    protected AbstractClassLoaderManager classLoaderManager = null;
    AtomicBoolean cacheResetFlag = new AtomicBoolean(false);
    final AtomicBoolean shutdownRequestFlag = new AtomicBoolean(false);
    final AtomicBoolean restart = new AtomicBoolean(false);
    boolean executing = false;

    protected void setupManagementParameters(TaskBundle bundle) {
        try {
            JMXServer jmxServer = this.getJmxServer();
            bundle.setParameter((Object)BundleParameter.NODE_MANAGEMENT_PORT_PARAM, (Object)jmxServer.getManagementPort());
            bundle.setParameter((Object)BundleParameter.NODE_PROVISIONING_MASTER, (Object)this.isMasterNode());
            bundle.setParameter((Object)BundleParameter.NODE_PROVISIONING_SLAVE, (Object)this.isSlaveNode());
            bundle.setParameter((Object)BundleParameter.NODE_DOTNET_CAPABLE, (Object)this.isDotnetCapable());
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)e));
        }
    }

    public AbstractJPPFClassLoader getClassLoader() {
        return this.classLoaderManager.getClassLoader();
    }

    public void setClassLoader(AbstractJPPFClassLoader cl) {
        this.classLoaderManager.setClassLoader(cl);
    }

    public JPPFContainer getContainer(List<String> uuidPath) throws Exception {
        return this.classLoaderManager.getContainer(uuidPath, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearResourceCachesIfRequested() {
        if (this.cacheResetFlag.get()) {
            try {
                this.classLoaderManager.clearResourceCaches();
            }
            finally {
                this.cacheResetFlag.set(false);
            }
        }
    }

    public void requestResourceCacheReset() {
        this.cacheResetFlag.compareAndSet(false, true);
    }

    public boolean requestShutdown(boolean restart) {
        if (this.shutdownRequestFlag.compareAndSet(false, true)) {
            this.restart.set(restart);
        }
        return this.shutdownRequestFlag.get();
    }

    public boolean cancelShutdownRequest() {
        return this.shutdownRequestFlag.compareAndSet(true, false);
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequestFlag.get();
    }

    public boolean isRestart() {
        return this.restart.get();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void setExecuting(boolean executing) {
        this.executing = executing;
    }
}

