/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.io.InvalidClassException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.node.protocol.AbstractTask;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.DataProvider;
import org.jppf.node.protocol.JPPFExceptionResult;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.server.node.DefaultSerializationExceptionHook;
import org.jppf.server.node.JPPFContainer;
import org.jppf.server.node.JPPFNode;
import org.jppf.server.node.NodeIO;
import org.jppf.server.node.SerializationExceptionHook;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.Pair;
import org.jppf.utils.hooks.HookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeIO
implements NodeIO {
    private static Logger log = LoggerFactory.getLogger(AbstractNodeIO.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static boolean traceEnabled = log.isTraceEnabled();
    protected final JPPFNode node;
    protected TaskBundle currentBundle = null;
    protected ObjectSerializer serializer = null;

    public AbstractNodeIO(JPPFNode node) {
        this.node = node;
        HookFactory.registerConfigSingleHook((String)"jppf.serialization.exception.hook", SerializationExceptionHook.class, (Object)new DefaultSerializationExceptionHook(), (ClassLoader)this.getClass().getClassLoader());
    }

    @Override
    public Pair<TaskBundle, List<Task<?>>> readTask() throws Exception {
        Object[] result = this.readObjects();
        this.currentBundle = (TaskBundle)result[0];
        LinkedList<Task> taskList = new LinkedList<Task>();
        if (!this.currentBundle.isHandshake() && this.currentBundle.getParameter((Object)BundleParameter.NODE_EXCEPTION_PARAM) == null) {
            DataProvider dataProvider = (DataProvider)result[1];
            for (int i = 0; i < this.currentBundle.getTaskCount(); ++i) {
                Task task = (Task)result[2 + i];
                task.setDataProvider(dataProvider);
                task.setInNode(true);
                taskList.add(task);
            }
        }
        return new Pair((Object)this.currentBundle, taskList);
    }

    protected Object[] readObjects() throws Exception {
        boolean reload;
        Object[] result;
        block6: {
            result = null;
            reload = false;
            try {
                result = this.deserializeObjects();
            }
            catch (IncompatibleClassChangeError err) {
                reload = true;
                if (debugEnabled) {
                    log.debug(err.getMessage() + "; reloading classes", (Throwable)err);
                }
            }
            catch (InvalidClassException e) {
                reload = true;
                if (!debugEnabled) break block6;
                log.debug(e.getMessage() + "; reloading classes", (Throwable)e);
            }
        }
        if (reload) {
            if (debugEnabled) {
                log.debug("reloading classes");
            }
            this.handleReload();
            result = this.deserializeObjects();
        }
        return result;
    }

    protected abstract void handleReload() throws Exception;

    protected abstract Object[] deserializeObjects() throws Exception;

    protected abstract Object[] deserializeObjects(TaskBundle var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeResults(TaskBundle bundle, List<Task<?>> tasks) throws Exception {
        try {
            bundle.setSLA(null);
            bundle.setMetadata(null);
            this.sendResults(bundle, tasks);
        }
        finally {
            this.postSendResults(bundle);
        }
    }

    protected abstract void sendResults(TaskBundle var1, List<Task<?>> var2) throws Exception;

    protected void postSendResults(TaskBundle bundle) throws Exception {
        if (!this.node.isOffline()) {
            if (debugEnabled) {
                log.debug("resetting remoteClassLoadingDisabled to false");
            }
            JPPFContainer cont = this.node.getContainer(bundle.getUuidPath().getList());
            cont.getClassLoader().setRemoteClassLoadingDisabled(false);
        }
    }

    protected void initializeBundleData(TaskBundle bundle) {
        bundle.setNodeExecutionTime(System.nanoTime());
    }

    protected void finalizeBundleData(TaskBundle bundle, List<Task<?>> tasks) {
        long elapsed = System.nanoTime() - bundle.getNodeExecutionTime();
        bundle.setNodeExecutionTime(elapsed);
        HashSet<Integer> resubmitSet = new HashSet<Integer>();
        for (Task<?> task : tasks) {
            if (!(task instanceof AbstractTask) || !((AbstractTask)task).isResubmit()) continue;
            resubmitSet.add(task.getPosition());
        }
        if (!resubmitSet.isEmpty()) {
            if (debugEnabled) {
                log.debug("positions of task resubmit requests: {}", resubmitSet);
            }
            int[] resubmitPos = new int[resubmitSet.size()];
            int count = 0;
            Iterator i$ = resubmitSet.iterator();
            while (i$.hasNext()) {
                int n = (Integer)i$.next();
                resubmitPos[count++] = n;
            }
            bundle.setParameter((Object)BundleParameter.RESUBMIT_TASK_POSITIONS, (Object)resubmitPos);
        }
    }

    protected class ObjectSerializationTask
    implements Callable<DataLocation> {
        private final Object object;

        public ObjectSerializationTask(Object object) {
            this.object = object;
        }

        @Override
        public DataLocation call() {
            ObjectSerializer ser = null;
            DataLocation dl = null;
            int p = this.object instanceof Task ? ((Task)this.object).getPosition() : -1;
            try {
                ser = AbstractNodeIO.this.node.getHelper().getSerializer();
                if (traceEnabled) {
                    log.trace("before serialization of object at position " + p);
                }
                dl = IOHelper.serializeData((Object)this.object, (ObjectSerializer)ser);
                int size = dl.getSize();
                if (traceEnabled) {
                    log.trace("serialized object at position " + p + ", size = " + size);
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
                try {
                    JPPFExceptionResult result = (JPPFExceptionResult)HookFactory.invokeSingleHook(SerializationExceptionHook.class, (String)"buildExceptionResult", (Object[])new Object[]{this.object, t});
                    result.setPosition(p);
                    dl = IOHelper.serializeData((Object)result, (ObjectSerializer)ser);
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
            }
            return dl;
        }
    }

    protected static class BufferList
    extends Pair<List<JPPFBuffer>, Integer> {
        public BufferList(List<JPPFBuffer> first, Integer second) {
            super(first, (Object)second);
        }
    }
}

