/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.serialization.SerializationHelper;
import org.jppf.server.node.SerializationExceptionHook;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.hooks.HookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JPPFContainer {
    private static Logger log = LoggerFactory.getLogger(JPPFContainer.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static boolean traceEnabled = log.isTraceEnabled();
    protected SerializationHelper helper = null;
    protected AbstractJPPFClassLoader classLoader = null;
    protected List<String> uuidPath = new ArrayList<String>();
    private Lock lock = new ReentrantLock();
    private final boolean sequentialDeserialization = JPPFConfiguration.getProperties().getBoolean("jppf.sequential.deserialization", false);

    public JPPFContainer(List<String> uuidPath, AbstractJPPFClassLoader classLoader) throws Exception {
        if (debugEnabled) {
            log.debug("new JPPFContainer with uuidPath=" + uuidPath + ", classLoader=" + classLoader);
        }
        this.uuidPath = uuidPath;
        this.classLoader = classLoader;
        this.init();
    }

    public final void init() throws Exception {
        this.initHelper();
    }

    public abstract int deserializeObjects(List<Object> var1, int var2, ExecutorService var3) throws Throwable;

    public AbstractJPPFClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(AbstractJPPFClassLoader classLoader) {
        this.classLoader = classLoader;
        try {
            this.initHelper();
        }
        catch (Exception e) {
            log.error("error setting new class loader", (Throwable)e);
        }
    }

    protected void initHelper() throws Exception {
        Class<?> c = this.getClassLoader().loadJPPFClass("org.jppf.utils.SerializationHelperImpl");
        Object o = c.newInstance();
        this.helper = (SerializationHelper)o;
    }

    public String getAppUuid() {
        return this.uuidPath.isEmpty() ? null : this.uuidPath.get(0);
    }

    public void setUuidPath(List<String> uuidPath) {
        this.uuidPath = uuidPath;
    }

    protected class ObjectDeserializationTask
    implements Callable<Object> {
        DataLocation dl = null;
        private int index = 0;

        public ObjectDeserializationTask(DataLocation dl, int index) {
            this.dl = dl;
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Object object;
                Thread.currentThread().setContextClassLoader(JPPFContainer.this.getClassLoader());
                if (traceEnabled) {
                    log.debug("deserializing object index = " + this.index);
                }
                if (JPPFContainer.this.sequentialDeserialization) {
                    JPPFContainer.this.lock.lock();
                }
                try {
                    object = IOHelper.unwrappedData((DataLocation)this.dl, (ObjectSerializer)JPPFContainer.this.helper.getSerializer());
                }
                catch (Throwable throwable) {
                    try {
                        if (JPPFContainer.this.sequentialDeserialization) {
                            JPPFContainer.this.lock.unlock();
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        String desc = (this.index == 0 ? "data provider" : "task at index " + this.index) + " could not be deserialized";
                        if (debugEnabled) {
                            log.debug("{} : {}", (Object)desc, (Object)ExceptionUtils.getStackTrace((Throwable)t));
                        } else {
                            log.error("{} : {}", (Object)desc, (Object)ExceptionUtils.getMessage((Throwable)t));
                        }
                        Object result = null;
                        if (this.index > 0) {
                            result = HookFactory.invokeSingleHook(SerializationExceptionHook.class, (String)"buildExceptionResult", (Object[])new Object[]{desc, t});
                        }
                        Object object2 = result;
                        return object2;
                    }
                }
                if (JPPFContainer.this.sequentialDeserialization) {
                    JPPFContainer.this.lock.unlock();
                }
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }
}

