/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jppf.JPPFError;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.execute.ExecutionManager;
import org.jppf.management.JMXServer;
import org.jppf.management.JMXServerFactory;
import org.jppf.management.JPPFNodeAdminMBean;
import org.jppf.management.spi.JPPFMBeanProviderManager;
import org.jppf.management.spi.JPPFNodeMBeanProvider;
import org.jppf.node.NodeRunner;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.node.event.LifeCycleEventHandler;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.node.provisioning.SlaveNodeManager;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.serialization.SerializationHelper;
import org.jppf.server.node.AbstractCommonNode;
import org.jppf.server.node.ClassLoaderProvider;
import org.jppf.server.node.NodeConnectionChecker;
import org.jppf.server.node.NodeExecutionManager;
import org.jppf.server.node.NodeIO;
import org.jppf.ssl.SSLConfigurationException;
import org.jppf.startup.JPPFNodeStartupSPI;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ManagementUtils;
import org.jppf.utils.Pair;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.hooks.HookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JPPFNode
extends AbstractCommonNode
implements ClassLoaderProvider {
    private static final Logger log = LoggerFactory.getLogger(JPPFNode.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    protected ExecutionManager executionManager = null;
    protected NodeIO nodeIO = null;
    private boolean jmxEnabled = JPPFConfiguration.getProperties().getBoolean("jppf.management.enabled", true);
    private final boolean dotnetCapable = JPPFConfiguration.getProperties().getBoolean("jppf.dotnet.bridge.initialized", false);
    private Runnable exitAction = null;
    private JPPFNodeAdminMBean nodeAdmin = null;
    private static JMXServer jmxServer = null;
    private JPPFMBeanProviderManager providerManager = null;
    protected LifeCycleEventHandler lifeCycleEventHandler = null;
    protected NodeConnectionChecker connectionChecker = null;
    protected final boolean checkConnection = JPPFConfiguration.getProperties().getBoolean("jppf.node.check.connection", false);
    protected Pair<TaskBundle, List<Task<?>>> currentBundle = null;

    public JPPFNode() {
        this.uuid = NodeRunner.getUuid();
        this.executionManager = new NodeExecutionManager(this);
        this.lifeCycleEventHandler = new LifeCycleEventHandler(this);
        this.updateSystemInformation();
    }

    @Override
    public void run() {
        this.setStopped(false);
        boolean initialized = false;
        if (debugEnabled) {
            log.debug("Start of node main loop, nodeUuid=" + this.uuid);
        }
        while (!this.isStopped()) {
            try {
                if (!this.isLocal() && NodeRunner.getShuttingDown().get()) break;
                this.init();
                if (!initialized) {
                    System.out.println("Node successfully initialized");
                    initialized = true;
                }
                this.perform();
            }
            catch (SecurityException | SSLConfigurationException e) {
                if (this.checkConnection) {
                    this.connectionChecker.stop();
                }
                if (!this.isStopped()) {
                    this.reset(true);
                }
                throw new JPPFError(e);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                if (this.checkConnection) {
                    this.connectionChecker.stop();
                }
                if (this.isStopped()) continue;
                this.reset(true);
                throw new JPPFNodeReconnectionNotification("I/O exception occurred during node processing", e, ConnectionReason.JOB_CHANNEL_PROCESSING_ERROR);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (this.checkConnection) {
                    this.connectionChecker.stop();
                }
                if (this.isStopped()) continue;
                this.reset(true);
            }
        }
        if (debugEnabled) {
            log.debug("End of node main loop");
        }
        if (this.exitAction != null) {
            Runnable r = this.exitAction;
            this.setExitAction(null);
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() throws Exception {
        if (debugEnabled) {
            log.debug("Start of node secondary loop");
        }
        while (!this.checkStopped()) {
            this.clearResourceCachesIfRequested();
            if (this.isShutdownRequested()) {
                this.shutdown(this.isRestart());
                continue;
            }
            try {
                this.processNextJob();
            }
            finally {
                this.setExecuting(false);
            }
        }
        if (debugEnabled) {
            log.debug("End of node secondary loop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextJob() throws Exception {
        Pair<TaskBundle, List<Task<?>>> pair = this.nodeIO.readTask();
        TaskBundle bundle = (TaskBundle)pair.first();
        List taskList = (List)pair.second();
        if (debugEnabled) {
            log.debug(!bundle.isHandshake() ? "received a bundle with " + taskList.size() + " tasks" : "received a handshake bundle");
        }
        if (!bundle.isHandshake()) {
            try {
                if (this.checkConnection) {
                    this.connectionChecker.resume();
                }
                this.executionManager.execute(bundle, taskList);
            }
            finally {
                if (this.checkConnection) {
                    this.connectionChecker.suspend();
                    if (this.connectionChecker.getException() != null) {
                        throw this.connectionChecker.getException();
                    }
                }
            }
            if (this.isOffline()) {
                this.currentBundle = pair;
                this.initDataChannel();
                this.processNextJob();
            } else {
                this.processResults(bundle, taskList);
            }
        } else {
            if (this.currentBundle != null) {
                bundle = (TaskBundle)this.currentBundle.first();
                taskList = (List)this.currentBundle.second();
            }
            this.checkInitialBundle(bundle);
            this.currentBundle = null;
            this.processResults(bundle, taskList);
            if (this.isMasterNode()) {
                SlaveNodeManager.handleStartup();
            }
        }
    }

    private void checkInitialBundle(TaskBundle bundle) throws Exception {
        this.checkStopped();
        if (debugEnabled) {
            log.debug("setting initial bundle, offline=" + this.isOffline() + (this.currentBundle == null ? ", bundle=" + bundle : ", currentBundle=" + this.currentBundle.first()));
        }
        bundle.setParameter((Object)BundleParameter.NODE_UUID_PARAM, (Object)this.uuid);
        if (this.isOffline()) {
            bundle.setParameter((Object)BundleParameter.NODE_OFFLINE, (Object)true);
            if (this.currentBundle != null) {
                bundle.setParameter((Object)BundleParameter.NODE_OFFLINE_OPEN_REQUEST, (Object)true);
                bundle.setParameter((Object)BundleParameter.NODE_BUNDLE_ID, ((TaskBundle)this.currentBundle.first()).getParameter((Object)BundleParameter.NODE_BUNDLE_ID));
                bundle.setParameter((Object)BundleParameter.JOB_UUID, (Object)((TaskBundle)this.currentBundle.first()).getUuid());
            }
        }
        if (this.isJmxEnabled()) {
            this.setupManagementParameters(bundle);
        }
    }

    private void processResults(TaskBundle bundle, List<Task<?>> taskList) throws Exception {
        this.checkStopped();
        this.currentBundle = null;
        if (debugEnabled) {
            log.debug("processing " + (taskList == null ? 0 : taskList.size()) + " task results for job '" + bundle.getName() + '\'');
        }
        if (this.executionManager.checkConfigChanged() || bundle.isHandshake() || this.isOffline()) {
            if (debugEnabled) {
                log.debug("detected configuration change or initial bundle request, sending new system information to the server");
            }
            TypedProperties jppf = this.systemInformation.getJppf();
            jppf.clear();
            jppf.putAll((Map)JPPFConfiguration.getProperties());
            bundle.setParameter((Object)BundleParameter.SYSTEM_INFO_PARAM, (Object)this.systemInformation);
        }
        this.nodeIO.writeResults(bundle, taskList);
        if (taskList != null && !taskList.isEmpty() && !this.isJmxEnabled()) {
            this.setTaskCount(this.getTaskCount() + taskList.size());
        }
        if (!bundle.isHandshake()) {
            this.lifeCycleEventHandler.fireBeforeNextJob();
        }
    }

    private synchronized void init() throws Exception {
        this.checkStopped();
        if (debugEnabled) {
            log.debug("start node initialization");
        }
        this.initHelper();
        try {
            if (ManagementUtils.isManagementAvailable() && !ManagementUtils.isMBeanRegistered((String)"org.jppf:name=admin,type=node")) {
                this.registerProviderMBeans();
            }
        }
        catch (Exception e) {
            log.error("Error registering the MBeans", (Throwable)e);
        }
        if (this.isJmxEnabled()) {
            JMXServer jmxServer = null;
            try {
                jmxServer = this.getJmxServer();
            }
            catch (Exception e) {
                this.jmxEnabled = false;
                System.out.println("JMX initialization failure - management is disabled for this node");
                System.out.println("see the log file for details");
                try {
                    if (jmxServer != null) {
                        jmxServer.stop();
                    }
                }
                catch (Exception e2) {
                    log.error("Error stopping the JMX server", (Throwable)e2);
                }
                jmxServer = null;
                log.error("Error creating the JMX server", (Throwable)e);
            }
        }
        HookFactory.registerSPIMultipleHook(JPPFNodeStartupSPI.class, null, null).invoke("run", new Object[0]);
        this.initDataChannel();
        if (this.checkConnection) {
            this.connectionChecker = this.createConnectionChecker();
            this.connectionChecker.start();
        }
        this.lifeCycleEventHandler.loadListeners();
        this.lifeCycleEventHandler.fireNodeStarting();
        if (debugEnabled) {
            log.debug("end node initialization");
        }
    }

    public abstract void initDataChannel() throws Exception;

    public abstract void closeDataChannel() throws Exception;

    public void initHelper() throws Exception {
        if (debugEnabled) {
            log.debug("Initializing serializer");
        }
        Class<?> c = this.getClassLoader().loadJPPFClass("org.jppf.utils.ObjectSerializerImpl");
        if (debugEnabled) {
            log.debug("Loaded serializer class " + c);
        }
        this.serializer = (ObjectSerializer)c.newInstance();
        c = this.getClassLoader().loadJPPFClass("org.jppf.utils.SerializationHelperImpl");
        if (debugEnabled) {
            log.debug("Loaded helper class " + c);
        }
        this.helper = (SerializationHelper)c.newInstance();
        if (debugEnabled) {
            log.debug("Serializer initialized");
        }
    }

    public synchronized JPPFNodeAdminMBean getNodeAdmin() {
        return this.nodeAdmin;
    }

    public synchronized void setNodeAdmin(JPPFNodeAdminMBean nodeAdmin) {
        this.nodeAdmin = nodeAdmin;
    }

    @Override
    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    boolean isJmxEnabled() {
        return this.jmxEnabled && !this.isOffline();
    }

    @Override
    public synchronized void stopNode() {
        if (debugEnabled) {
            log.debug("stopping node");
        }
        this.setStopped(true);
        this.executionManager.shutdown();
        this.reset(true);
    }

    public void shutdown(boolean restart) {
        if (!this.isLocal()) {
            this.setStopped(true);
            this.lifeCycleEventHandler.fireNodeEnding();
            NodeRunner.shutdown(this, restart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(boolean stopJmx) {
        if (debugEnabled) {
            log.debug("resetting with stopJmx=" + stopJmx);
        }
        System.out.println("resetting with stopJmx=" + stopJmx);
        this.lifeCycleEventHandler.fireNodeEnding();
        this.lifeCycleEventHandler.removeAllListeners();
        this.setNodeAdmin(null);
        if (stopJmx) {
            try {
                if (this.providerManager != null) {
                    this.providerManager.unregisterProviderMBeans();
                }
                if (jmxServer != null) {
                    jmxServer.stop();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.classLoaderManager.closeClassLoader();
        try {
            JPPFNode e = this;
            synchronized (e) {
                this.closeDataChannel();
            }
            this.classLoaderManager.clearContainers();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void setExitAction(Runnable exitAction) {
        this.exitAction = exitAction;
    }

    private void registerProviderMBeans() throws Exception {
        ClassLoader cl = this.getClass().getClassLoader();
        if (this.providerManager == null) {
            this.providerManager = new JPPFMBeanProviderManager(JPPFNodeMBeanProvider.class, cl, ManagementUtils.getPlatformServer(), new Object[]{this});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMXServer getJmxServer() throws Exception {
        JPPFNode jPPFNode = this;
        synchronized (jPPFNode) {
            if (jmxServer == null || jmxServer.isStopped()) {
                boolean ssl = JPPFConfiguration.getProperties().getBoolean("jppf.ssl.enabled", false);
                jmxServer = JMXServerFactory.createServer((String)NodeRunner.getUuid(), (boolean)ssl, (String[])new String[]{"jppf.node.management.port", "jppf.management.port"});
                jmxServer.start(this.getClass().getClassLoader());
                System.out.println("JPPF Node management initialized on port " + jmxServer.getManagementPort());
            }
        }
        return jmxServer;
    }

    public void stopJmxServer() throws Exception {
        if (jmxServer != null) {
            jmxServer.stop();
        }
    }

    @Override
    public LifeCycleEventHandler getLifeCycleEventHandler() {
        return this.lifeCycleEventHandler;
    }

    protected abstract NodeConnectionChecker createConnectionChecker();

    public void triggerConfigChanged() {
        this.updateSystemInformation();
        this.executionManager.triggerConfigChanged();
    }

    @Override
    public AbstractJPPFClassLoader resetTaskClassLoader(Object ... params) {
        TaskBundle bundle = this.executionManager.getBundle();
        if (bundle == null) {
            return null;
        }
        try {
            List uuidPath = bundle.getUuidPath().getList();
            boolean remoteClassLoadingDisabled = this.classLoaderManager.getContainer(uuidPath, params).getClassLoader().isRemoteClassLoadingDisabled();
            AbstractJPPFClassLoader newCL = this.classLoaderManager.resetClassLoader(uuidPath, params);
            newCL.setRemoteClassLoadingDisabled(remoteClassLoadingDisabled);
            return newCL;
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public ClassLoader getClassLoader(List<String> uuidPath) throws Exception {
        return this.getContainer(uuidPath).getClassLoader();
    }

    @Override
    public boolean isOffline() {
        return this.getClassLoader().isOffline();
    }

    @Override
    public boolean isMasterNode() {
        return !this.isOffline() && this.systemInformation != null && this.systemInformation.getJppf().getBoolean("jppf.node.provisioning.master", true);
    }

    @Override
    public boolean isSlaveNode() {
        return this.systemInformation != null && this.systemInformation.getJppf().getBoolean("jppf.node.provisioning.slave", false);
    }

    private boolean checkStopped() {
        if (this.isStopped()) {
            throw new IllegalStateException("this node is shutting down");
        }
        return false;
    }

    @Override
    public boolean isDotnetCapable() {
        return this.dotnetCapable;
    }
}

