/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.util.ArrayList;
import java.util.List;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.execute.AbstractExecutionManager;
import org.jppf.node.NodeInternal;
import org.jppf.node.event.LifeCycleEventHandler;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.node.ClassLoaderProvider;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeExecutionManager
extends AbstractExecutionManager {
    private static final Logger log = LoggerFactory.getLogger(NodeExecutionManager.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private NodeInternal node = null;

    public NodeExecutionManager(NodeInternal node) {
        this(node, "jppf.processing.threads", "processing.threads");
    }

    public NodeExecutionManager(NodeInternal node, String nbThreadsProperty, String legacyNbThreadsProperty) {
        super(nbThreadsProperty, legacyNbThreadsProperty);
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        this.node = node;
    }

    protected void setup(TaskBundle bundle, List<Task<?>> taskList) {
        this.bundle = bundle;
        this.taskNotificationDispatcher.setBundle(this.bundle);
        this.taskList = taskList;
        this.taskWrapperList = new ArrayList(taskList.size());
        this.dataProvider = taskList.get(0).getDataProvider();
        this.uuidList = bundle.getUuidPath().getList();
        ClassLoader taskClassLoader = null;
        try {
            taskClassLoader = this.node instanceof ClassLoaderProvider ? ((ClassLoaderProvider)((Object)this.node)).getClassLoader(this.uuidList) : this.getTaskClassLoader(taskList.get(0));
            this.usedClassLoader = this.threadManager.useClassLoader(taskClassLoader);
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getMessage((Throwable)e) + " - class loader lookup failed for uuidPath=" + this.uuidList;
            if (debugEnabled) {
                log.debug(msg, (Throwable)e);
            }
            log.warn(msg);
        }
        this.accumulatedElapsed.set(0L);
        LifeCycleEventHandler handler = this.node.getLifeCycleEventHandler();
        if (handler != null) {
            handler.fireJobStarting((JPPFDistributedJob)bundle, taskClassLoader instanceof AbstractJPPFClassLoader ? (AbstractJPPFClassLoader)taskClassLoader : null, taskList, this.dataProvider);
        }
    }

    protected void cleanup() {
        this.bundle.setParameter((Object)BundleParameter.NODE_BUNDLE_ELAPSED_PARAM, (Object)this.accumulatedElapsed.get());
        ClassLoader cl = this.usedClassLoader.getClassLoader();
        LifeCycleEventHandler handler = this.node.getLifeCycleEventHandler();
        if (handler != null) {
            handler.fireJobEnding((JPPFDistributedJob)this.bundle, cl instanceof AbstractJPPFClassLoader ? (AbstractJPPFClassLoader)cl : null, this.taskList, this.dataProvider);
        }
        this.dataProvider = null;
        this.usedClassLoader.dispose();
        this.usedClassLoader = null;
        this.bundle = null;
        this.taskNotificationDispatcher.setBundle(null);
        this.taskList = null;
        this.uuidList = null;
        this.setJobCancelled(false);
        this.taskWrapperList = null;
        this.timeoutHandler.clear();
    }

    private ClassLoader getTaskClassLoader(Task<?> task) {
        return task.getTaskClassLoader();
    }
}

