/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jppf.JPPFException;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.classloader.ClassLoaderConnection;
import org.jppf.classloader.ClassLoaderRequestHandler;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceFuture;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.classloader.ResourceRequestRunner;
import org.jppf.node.AbstractNodeConnection;
import org.jppf.node.NodeRunner;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TraversalList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassLoaderConnection<C>
extends AbstractNodeConnection<C>
implements ClassLoaderConnection<C> {
    private static Logger log = LoggerFactory.getLogger(AbstractClassLoaderConnection.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    protected ClassLoaderRequestHandler requestHandler;

    protected void performCommonHandshake(ResourceRequestRunner requestRunner) {
        try {
            if (debugEnabled) {
                log.debug("sending node initiation message");
            }
            JPPFResourceWrapper request = new JPPFResourceWrapper();
            request.setState(JPPFResourceWrapper.State.NODE_INITIATION);
            request.setData(ResourceIdentifier.NODE_UUID, (Object)NodeRunner.getUuid());
            requestRunner.setRequest(request);
            requestRunner.run();
            Throwable t = requestRunner.getThrowable();
            if (t != null) {
                if (debugEnabled) {
                    log.debug("handshake error from {} for request = {}: {}", new Object[]{this, request, ExceptionUtils.getMessage((Throwable)t)});
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
            if (debugEnabled) {
                log.debug("received node initiation response");
            }
            requestRunner.reset();
            this.requestHandler = new ClassLoaderRequestHandler(requestRunner);
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new JPPFNodeReconnectionNotification("Could not reconnect to the driver", e, ConnectionReason.CLASSLOADER_INIT_ERROR);
        }
        catch (Exception e) {
            log.error("error during class loader handshake, connection = {}", (Object)this, (Object)e);
            throw new RuntimeException(e);
        }
    }

    protected void sendCloseChannelCommand(ResourceRequestRunner requestRunner) {
        try {
            if (debugEnabled) {
                log.debug("sending close channel command");
            }
            JPPFResourceWrapper request = new JPPFResourceWrapper();
            request.setState(JPPFResourceWrapper.State.CLOSE_CHANNEL);
            request.setData(ResourceIdentifier.NODE_UUID, (Object)NodeRunner.getUuid());
            requestRunner.setRequest(request);
            requestRunner.run();
            Throwable t = requestRunner.getThrowable();
            if (t != null) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
            if (debugEnabled) {
                log.debug("received node response");
            }
            requestRunner.reset();
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug("error sending close channel command from {}:\n{}", (Object)this, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            log.warn("error sending close channel command form {}: {}", (Object)this, (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    @Override
    public JPPFResourceWrapper loadResource(Map<ResourceIdentifier, Object> map, boolean dynamic, String requestUuid, List<String> uuidPath) throws Exception {
        JPPFResourceWrapper resource = new JPPFResourceWrapper();
        resource.setState(JPPFResourceWrapper.State.NODE_REQUEST);
        resource.setDynamic(dynamic);
        TraversalList list = new TraversalList(uuidPath);
        resource.setUuidPath(list);
        if (list.size() > 0) {
            list.setPosition(uuidPath.size() - 1);
        }
        for (Map.Entry<ResourceIdentifier, Object> entry : map.entrySet()) {
            resource.setData(entry.getKey(), entry.getValue());
        }
        resource.setRequestUuid(requestUuid);
        Future<JPPFResourceWrapper> f = this.requestHandler.addRequest(resource);
        resource = f.get();
        Throwable t = ((ResourceFuture)f).getThrowable();
        if (t != null) {
            if (debugEnabled) {
                log.debug("error loading resource {} from {}: {}", new Object[]{resource, this, ExceptionUtils.getMessage((Throwable)t)});
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new JPPFException(t);
        }
        return resource;
    }

    public ClassLoaderRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    @Override
    public void reset() throws Exception {
        this.lock.lock();
        try {
            this.init();
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug("{} could not reconnect to the server after connection reset: {}", (Object)this, (Object)ExceptionUtils.getMessage((Throwable)e));
            }
            throw new JPPFNodeReconnectionNotification("Could not reconnect to the server after connection reset", e, ConnectionReason.CLASSLOADER_INIT_ERROR);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "channel=" + this.channel + ", initializing=" + this.initializing + ", requestHandler=" + this.requestHandler + ']';
    }
}

