/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import org.jppf.classloader.AbstractJPPFClassLoaderLifeCycle;
import org.jppf.classloader.ClassLoaderConnection;
import org.jppf.classloader.ClassLoaderEvent;
import org.jppf.classloader.ClassLoaderListener;
import org.jppf.classloader.DelegationModel;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFCallable;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.StringUtils;
import org.jppf.utils.collections.IteratorEnumeration;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.jppf.utils.hooks.HookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFClassLoader
extends AbstractJPPFClassLoaderLifeCycle {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClassLoader.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static DelegationModel delegationModel = AbstractJPPFClassLoader.initDelegationModel();
    private ClassLoader systemClassLoader = null;
    private boolean systemClassLoaderInitialized = false;

    public AbstractJPPFClassLoader(ClassLoaderConnection<?> connection, ClassLoader parent) {
        super(connection, parent, null);
    }

    public AbstractJPPFClassLoader(ClassLoaderConnection<?> connection, ClassLoader parent, List<String> uuidPath) {
        super(connection, parent, uuidPath);
    }

    public synchronized Class<?> loadJPPFClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{"looking up resource [", name, "]"}));
        }
        if ((c = this.findLoadedClass(name)) == null) {
            if (debugEnabled) {
                log.debug(StringUtils.build((Object[])new Object[]{"resource [", name, "] not already loaded"}));
            }
            Class<?> clazz = c = this.isRemoteClassLoadingDisabled() ? Class.forName(name, true, this) : this.findClass(name, false);
        }
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{"definition for resource [", name, "] : ", c}));
        }
        if (c != null && debugEnabled) {
            log.debug("class '" + name + "' loaded by " + c.getClassLoader());
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    protected synchronized Class<?> findClass(String name, boolean lookupClasspath) throws ClassNotFoundException {
        String pkgName;
        Package pkg;
        Class<?> c = null;
        if (this.notFoundCache.has((Object)name)) {
            throw new ClassNotFoundException(StringUtils.build((Object[])new Object[]{"Could not load class '", name, "'"}));
        }
        c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (lookupClasspath && (c = this.findClassInURLClasspath(name, false)) != null) {
            this.fireEvent(c, null, true);
            return c;
        }
        if (this.isRemoteClassLoadingDisabled()) {
            this.notFoundCache.add((Object)name);
            throw new ClassNotFoundException(StringUtils.build((Object[])new Object[]{"Could not load class '", name, "'"}));
        }
        int i = name.lastIndexOf(46);
        if (i >= 0 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{"looking up definition for resource [", name, "]"}));
        }
        byte[] b = null;
        String resName = name.replace('.', '/') + ".class";
        EnumMap<ResourceIdentifier, Object> map = new EnumMap<ResourceIdentifier, Object>(ResourceIdentifier.class);
        map.put(ResourceIdentifier.NAME, (Object)resName);
        JPPFResourceWrapper resource = null;
        resource = this.loadResource(map);
        if (resource != null) {
            b = resource.getDefinition();
        }
        if (b == null || b.length == 0) {
            if (debugEnabled) {
                log.debug("definition for resource [" + name + "] not found");
            }
            if (resource != null && resource.getState() != JPPFResourceWrapper.State.NODE_RESPONSE_ERROR) {
                this.notFoundCache.add((Object)name);
            }
            this.fireEvent(null, name, false);
            throw new ClassNotFoundException(StringUtils.build((Object[])new Object[]{"Could not load class '", name, "'"}));
        }
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{"found definition for resource [", name, ", definitionLength=", b.length, "]"}));
        }
        if ((c = this.findLoadedClass(name)) == null) {
            c = this.defineClass(name, b, 0, b.length);
        }
        this.fireEvent(c, null, false);
        return c;
    }

    public <V> V computeCallable(JPPFCallable<V> callable) throws Exception {
        Object returned = null;
        Class<?> clazz = this.loadJPPFClass("org.jppf.utils.ObjectSerializerImpl");
        ObjectSerializer ser = (ObjectSerializer)clazz.newInstance();
        byte[] bytes = ser.serialize(callable).getBuffer();
        if ((bytes = this.computeRemoteData(bytes)) == null) {
            return null;
        }
        returned = ser.deserialize(bytes);
        if (returned instanceof Exception) {
            throw (Exception)returned;
        }
        return (V)returned;
    }

    public byte[] computeRemoteData(byte[] callable) throws Exception {
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{this, " requesting remote computation, requestUuid = ", this.requestUuid}));
        }
        EnumMap<ResourceIdentifier, Object> map = new EnumMap<ResourceIdentifier, Object>(ResourceIdentifier.class);
        map.put(ResourceIdentifier.NAME, (Object)"callable");
        map.put(ResourceIdentifier.CALLABLE, (Object)callable);
        JPPFResourceWrapper resource = this.connection.loadResource(map, this.dynamic, this.requestUuid, this.uuidPath);
        byte[] b = null;
        if (resource != null && resource.getState() == JPPFResourceWrapper.State.NODE_RESPONSE) {
            b = resource.getCallable();
        }
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{this, " remote definition for callable resource ", b == null ? "not " : "", "found"}));
        }
        return b;
    }

    @Override
    public URL findResource(String name) {
        URL url = null;
        if (this.notFoundCache.has((Object)name)) {
            return null;
        }
        if (this.resourceCache.isEnabled()) {
            url = this.resourceCache.getResourceURL(name);
            if (debugEnabled) {
                log.debug(StringUtils.build((Object[])new Object[]{this, " resource [", name, "] ", url == null ? "not " : "", "found in local cache"}));
            }
        }
        if (url == null) {
            url = super.findResource(name);
            if (debugEnabled) {
                log.debug(StringUtils.build((Object[])new Object[]{this, " resource [", name, "] ", url == null ? "not " : "", "found in URL classpath"}));
            }
            if (!this.isRemoteClassLoadingDisabled() && url == null) {
                if (debugEnabled) {
                    log.debug(StringUtils.build((Object[])new Object[]{this, " resource [", name, "] not found locally, attempting remote lookup"}));
                }
                try {
                    List<URL> urlList = this.findRemoteResources(name);
                    if (urlList != null && !urlList.isEmpty()) {
                        url = urlList.get(0);
                    }
                }
                catch (Exception e) {
                    if (debugEnabled) {
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                    log.warn(ExceptionUtils.getMessage((Throwable)e));
                }
                if (debugEnabled) {
                    log.debug(StringUtils.build((Object[])new Object[]{this, " resource [", name, "] ", url == null ? "not " : "", "found remotely"}));
                }
            }
        }
        if (url == null) {
            this.notFoundCache.add((Object)name);
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        try {
            URL url = this.getResource(name);
            if (url != null) {
                URLConnection connection = url.openConnection();
                is = connection.getInputStream();
            }
            if (debugEnabled) {
                log.debug(StringUtils.build((Object[])new Object[]{this, " lookup for '", name, "' = ", url, " for ", this}));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return is;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        List<Object> urlList = new ArrayList();
        if (!this.notFoundCache.has((Object)name)) {
            if (debugEnabled) {
                log.debug(StringUtils.build((Object[])new Object[]{this, " resource [", name, "] not found locally, attempting remote lookup"}));
            }
            try {
                Enumeration<URL> tempEnum;
                List<URL> tempList;
                if (this.resourceCache.isEnabled()) {
                    urlList = this.resourceCache.getResourcesURLs(name);
                }
                if (urlList == null) {
                    urlList = new ArrayList();
                }
                if (!this.isRemoteClassLoadingDisabled() && (tempList = this.findRemoteResources(name)) != null) {
                    urlList.addAll(tempList);
                }
                if ((tempEnum = super.findResources(name)) != null) {
                    while (tempEnum.hasMoreElements()) {
                        urlList.add(tempEnum.nextElement());
                    }
                }
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                } else {
                    log.warn(ExceptionUtils.getMessage((Throwable)e));
                }
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }
        if (urlList.isEmpty()) {
            this.notFoundCache.add((Object)name);
        }
        return new IteratorEnumeration(urlList.iterator());
    }

    private List<URL> findRemoteResources(String name) throws Exception {
        List<URL> urlList = new ArrayList<URL>();
        JPPFResourceWrapper resource = null;
        if (!this.notFoundCache.has((Object)name)) {
            boolean found;
            EnumMap<ResourceIdentifier, Object> map = new EnumMap<ResourceIdentifier, Object>(ResourceIdentifier.class);
            map.put(ResourceIdentifier.NAME, (Object)name);
            map.put(ResourceIdentifier.MULTIPLE, (Object)"true");
            resource = this.loadResource(map);
            List dataList = null;
            if (resource != null) {
                dataList = (List)resource.getData(ResourceIdentifier.RESOURCE_LIST);
            }
            boolean bl = found = dataList != null && !dataList.isEmpty();
            if (debugEnabled) {
                log.debug(StringUtils.build((Object[])new Object[]{this, "resource [", name, "] ", found ? "" : "not ", "found remotely"}));
            }
            if (found && this.resourceCache.isEnabled()) {
                this.resourceCache.registerResources(name, dataList);
                urlList = this.resourceCache.getResourcesURLs(name);
            }
        }
        if (urlList == null || urlList.isEmpty() && resource != null && resource.getState() != JPPFResourceWrapper.State.NODE_RESPONSE_ERROR) {
            this.notFoundCache.add((Object)name);
        }
        return urlList;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        DelegationModel model = AbstractJPPFClassLoader.getDelegationModel();
        switch (model) {
            case URL_FIRST: {
                return this.loadClassLocalFirst(name, resolve);
            }
            case PARENT_FIRST: {
                return super.loadClass(name, resolve);
            }
        }
        throw new IllegalStateException("unknown class loader delegation model " + model);
    }

    private Class<?> loadClassLocalFirst(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader cl;
        Class<?> c = this.findLoadedClass(name);
        if (c == null && (cl = this.initSystemClassLoader()) != null) {
            try {
                c = cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null) {
            ClassLoader p = this.getParent();
            boolean jppfCL = p instanceof AbstractJPPFClassLoader;
            if (!jppfCL) {
                try {
                    c = p.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                c = ((AbstractJPPFClassLoader)p).findClassInURLClasspath(name, false);
            }
            if (c == null) {
                c = this.findClassInURLClasspath(name, false);
            }
            if (c == null && jppfCL) {
                try {
                    c = ((AbstractJPPFClassLoader)p).findClass(name, false);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                c = this.findClass(name, false);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private ClassLoader initSystemClassLoader() {
        block3: {
            if (!this.systemClassLoaderInitialized) {
                this.systemClassLoaderInitialized = true;
                try {
                    this.systemClassLoader = AbstractJPPFClassLoader.getSystemClassLoader();
                }
                catch (Exception e) {
                    if (!debugEnabled) break block3;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.systemClassLoader;
    }

    private synchronized Class<?> findClassInURLClasspath(String name, boolean recursive) {
        Class<?> c;
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{"looking up up resource [", name, "] in the URL classpath for ", this}));
        }
        if ((c = this.findLoadedClass(name)) == null) {
            if (recursive && this.getParent() instanceof AbstractJPPFClassLoader) {
                c = ((AbstractJPPFClassLoader)this.getParent()).findClassInURLClasspath(name, recursive);
            }
            if (c == null) {
                try {
                    c = super.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{"resource [", name, "] ", c == null ? "not " : "", "found in the URL classpath for ", this}));
        }
        return c;
    }

    public static synchronized DelegationModel getDelegationModel() {
        return delegationModel;
    }

    public static synchronized void setDelegationModel(DelegationModel model) {
        if (model != null) {
            delegationModel = model;
        }
    }

    private static synchronized DelegationModel initDelegationModel() {
        DelegationModel model;
        String s = (String)JPPFConfiguration.get((JPPFProperty)JPPFProperties.CLASSLOADER_DELEGATION);
        DelegationModel delegationModel = model = "url".equalsIgnoreCase(s) ? DelegationModel.URL_FIRST : DelegationModel.PARENT_FIRST;
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{"Using ", model, " class loader delegation model"}));
        }
        return model;
    }

    public void clearNotFoundCache() {
        this.notFoundCache.clear();
    }

    @Override
    public void close() {
        this.resourceCache.close();
        this.notFoundCache.clear();
        super.close();
    }

    protected void fireEvent(Class<?> c, String name, boolean foundInURLClassPath) {
        boolean found = c != null;
        ClassLoaderEvent event = found ? new ClassLoaderEvent(this, c, foundInURLClassPath) : new ClassLoaderEvent(this, name);
        HookFactory.invokeHook(ClassLoaderListener.class, (String)(found ? "classLoaded" : "classNotFound"), (Object[])new Object[]{event});
    }

    public boolean isClientClassLoader() {
        return this.dynamic;
    }

    public boolean isServerClassLoader() {
        return !this.dynamic;
    }

    @Override
    public URL getResource(String name) {
        List<URL> urls;
        List<URL> list = urls = this.resourceCache.isEnabled() ? this.resourceCache.getResourcesURLs(name) : null;
        if (urls == null) {
            return super.getResource(name);
        }
        if (urls.isEmpty()) {
            return null;
        }
        return urls.get(0);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        List<URL> urls;
        List<URL> list = urls = this.resourceCache.isEnabled() ? this.resourceCache.getResourcesURLs(name) : null;
        if (urls == null) {
            return super.getResources(name);
        }
        return new IteratorEnumeration(urls.iterator());
    }
}

