/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.caching.JPPFCollectionCache;
import org.jppf.caching.JPPFSimpleSetCache;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.ClassLoaderConnection;
import org.jppf.classloader.ClassLoaderListener;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.classloader.resource.ResourceCache;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.StringUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.jppf.utils.hooks.HookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFClassLoaderLifeCycle
extends URLClassLoader {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClassLoaderLifeCycle.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    private static final boolean FILE_LOOKUP = (Boolean)JPPFConfiguration.get((JPPFProperty)JPPFProperties.CLASSLOADER_FILE_LOOKUP);
    protected boolean dynamic;
    protected List<String> uuidPath = new ArrayList<String>();
    protected String requestUuid = null;
    protected ResourceCache resourceCache = AbstractJPPFClassLoaderLifeCycle.createResourceCache();
    protected final JPPFCollectionCache<String> notFoundCache = new JPPFSimpleSetCache();
    protected final int instanceNumber = INSTANCE_COUNT.incrementAndGet();
    protected ClassLoaderConnection<?> connection;
    protected final boolean offline;
    protected final AtomicBoolean remoteClassLoadingDisabled = new AtomicBoolean(false);

    protected AbstractJPPFClassLoaderLifeCycle(ClassLoaderConnection<?> connection, ClassLoader parent, List<String> uuidPath) {
        super(StringUtils.ZERO_URL, parent);
        this.connection = connection;
        this.dynamic = parent instanceof AbstractJPPFClassLoaderLifeCycle;
        boolean bl = this.dynamic ? ((AbstractJPPFClassLoaderLifeCycle)parent).isOffline() : (this.offline = connection == null);
        if (uuidPath != null) {
            this.uuidPath = uuidPath;
        }
        HookFactory.registerSPIMultipleHook(ClassLoaderListener.class, null, null);
    }

    protected void init() {
        if (!this.isOffline()) {
            try {
                this.connection.init();
            }
            catch (Exception e) {
                throw new JPPFNodeReconnectionNotification("Could not reconnect to the server", e, ConnectionReason.CLASSLOADER_INIT_ERROR);
            }
        } else {
            System.out.println("This node is 'offline', no class loader connection is established");
        }
    }

    protected abstract void reset();

    protected JPPFResourceWrapper loadResource(Map<ResourceIdentifier, Object> map) throws ClassNotFoundException {
        JPPFResourceWrapper resource;
        block8: {
            resource = null;
            if (!this.isRemoteClassLoadingDisabled()) {
                try {
                    if (debugEnabled) {
                        log.debug(StringUtils.build((Object[])new Object[]{this, " loading remote definition for resource [", map.get("name"), "]"}));
                    }
                    map.put(ResourceIdentifier.FILE_LOOKUP_ALLOWED, FILE_LOOKUP);
                    resource = this.connection.loadResource(map, this.dynamic, this.requestUuid, this.uuidPath);
                    if (debugEnabled) {
                        log.debug(StringUtils.build((Object[])new Object[]{this, " remote definition for resource [", map.get("name") + "] ", resource.getDefinition() == null ? "not " : "", "found"}));
                    }
                }
                catch (IOException e) {
                    if (debugEnabled) {
                        log.debug(this.toString() + " connection with class server ended, re-initializing, exception is:", (Throwable)e);
                    }
                    throw new JPPFNodeReconnectionNotification("connection with class server ended, re-initializing, exception is:", e, ConnectionReason.CLASSLOADER_PROCESSING_ERROR);
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!debugEnabled) break block8;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return resource;
    }

    public String getRequestUuid() {
        return this.requestUuid;
    }

    public void setRequestUuid(String requestUuid) {
        this.requestUuid = requestUuid;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[id=").append(this.instanceNumber).append(", type=").append(this.dynamic ? "client" : "server");
        sb.append(", uuidPath=").append(this.uuidPath);
        sb.append(", offline=").append(this.offline);
        URL[] urls = this.getURLs();
        sb.append(", classpath=");
        if (urls != null && urls.length > 0) {
            for (int i = 0; i < urls.length; ++i) {
                if (i > 0) {
                    sb.append(';');
                }
                sb.append(urls[i]);
            }
        }
        sb.append(']');
        return sb.toString();
    }

    protected URL[] findMultipleResources(String ... names) {
        if (names == null || names.length <= 0) {
            return StringUtils.ZERO_URL;
        }
        URL[] results = new URL[names.length];
        boolean[] alreadyNotFound = new boolean[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = null;
            alreadyNotFound[i] = this.notFoundCache.has((Object)names[i]);
        }
        try {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < names.length; ++i) {
                List<URL> locationsList;
                if (alreadyNotFound[i]) continue;
                String name = names[i];
                List<URL> list = locationsList = this.resourceCache.isEnabled() ? this.resourceCache.getResourcesURLs(name) : null;
                if (locationsList != null && !locationsList.isEmpty()) {
                    results[i] = locationsList.get(0);
                    if (!debugEnabled) continue;
                    log.debug(StringUtils.build((Object[])new Object[]{this, " resource ", name, " found in local cache as ", results[i]}));
                    continue;
                }
                URL url = super.findResource(names[i]);
                if (url != null) {
                    results[i] = url;
                    if (!debugEnabled) continue;
                    log.debug(StringUtils.build((Object[])new Object[]{this, " resource ", name, " found in URL classpath as ", results[i]}));
                    continue;
                }
                if (debugEnabled) {
                    log.debug(StringUtils.build((Object[])new Object[]{"resource ", name, " not found locally"}));
                }
                indices.add(i);
            }
            if (indices.isEmpty() || this.isRemoteClassLoadingDisabled()) {
                if (debugEnabled) {
                    if (this.isRemoteClassLoadingDisabled()) {
                        log.debug(this.toString() + " offline mode: resources were looked up locally only");
                    } else {
                        log.debug(this.toString() + " all resources were found locally");
                    }
                }
                return results;
            }
            EnumMap<ResourceIdentifier, Object> map = new EnumMap<ResourceIdentifier, Object>(ResourceIdentifier.class);
            Object[] namesToLookup = new String[indices.size()];
            for (int i = 0; i < indices.size(); ++i) {
                namesToLookup[i] = names[(Integer)indices.get(i)];
            }
            map.put(ResourceIdentifier.NAME, (Object)StringUtils.arrayToString((String)", ", null, null, (Object[])namesToLookup));
            map.put(ResourceIdentifier.MULTIPLE_NAMES, (Object)namesToLookup);
            JPPFResourceWrapper resource = this.loadResource(map);
            Map dataMap = (Map)resource.getData(ResourceIdentifier.RESOURCE_MAP);
            for (Integer index : indices) {
                boolean found;
                String name = names[index];
                List dataList = (List)dataMap.get(name);
                boolean bl = found = dataList != null && !dataList.isEmpty();
                if (debugEnabled && !found) {
                    log.debug(StringUtils.build((Object[])new Object[]{this, " resource [", name, "] not found remotely"}));
                }
                if (found) {
                    URL url;
                    this.resourceCache.registerResources(name, dataList);
                    results[index.intValue()] = url = this.resourceCache.getResourceURL(name);
                    if (!debugEnabled) continue;
                    log.debug(StringUtils.build((Object[])new Object[]{this, " resource [", name, "] found remotely as ", url}));
                    continue;
                }
                if (resource.getState() == JPPFResourceWrapper.State.NODE_RESPONSE_ERROR) continue;
                this.notFoundCache.add((Object)name);
            }
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)e));
        }
        return results;
    }

    public URL[] getMultipleResources(String ... names) {
        URL[] results;
        block15: {
            if (names == null || names.length <= 0) {
                return StringUtils.ZERO_URL;
            }
            int length = names.length;
            results = new URL[length];
            boolean[] alreadyNotFound = new boolean[length];
            for (int i = 0; i < length; ++i) {
                results[i] = null;
                alreadyNotFound[i] = this.notFoundCache.has((Object)names[i]);
            }
            try {
                int i;
                ClassLoader parent = this.getParent();
                if (parent == null) {
                    for (i = 0; i < length; ++i) {
                        if (alreadyNotFound[i]) continue;
                        results[i] = AbstractJPPFClassLoaderLifeCycle.getSystemResource(names[i]);
                    }
                } else if (!(parent instanceof AbstractJPPFClassLoader)) {
                    for (i = 0; i < length; ++i) {
                        if (alreadyNotFound[i]) continue;
                        results[i] = parent.getResource(names[i]);
                    }
                } else {
                    results = ((AbstractJPPFClassLoader)parent).getMultipleResources(names);
                }
                for (i = 0; i < length; ++i) {
                    if (results[i] != null) continue;
                    results[i] = super.getResource(names[i]);
                }
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i2 = 0; i2 < length; ++i2) {
                    if (results[i2] != null) continue;
                    indices.add(i2);
                }
                if (!indices.isEmpty()) {
                    String[] namesToFind = new String[indices.size()];
                    for (int i3 = 0; i3 < namesToFind.length; ++i3) {
                        namesToFind[i3] = names[(Integer)indices.get(i3)];
                    }
                    URL[] foundURLs = this.findMultipleResources(namesToFind);
                    for (int i4 = 0; i4 < namesToFind.length; ++i4) {
                        results[((Integer)indices.get((int)i4)).intValue()] = foundURLs[i4];
                    }
                }
            }
            catch (Exception e) {
                if (!debugEnabled) break block15;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return results;
    }

    public ClassLoaderConnection<?> getConnection() {
        return this.connection;
    }

    public String getClientUuid() {
        if (!this.dynamic) {
            return null;
        }
        return this.uuidPath.get(0);
    }

    public void resetResourceCache() {
        if (this.resourceCache != null) {
            this.resourceCache.close();
            this.resourceCache = AbstractJPPFClassLoaderLifeCycle.createResourceCache();
        }
    }

    @Override
    public void close() {
        block4: {
            if (debugEnabled) {
                log.debug("closing classloader " + this);
            }
            try {
                super.close();
            }
            catch (IOException | NoSuchMethodError e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), e);
                }
                if (this.isOffline()) break block4;
                log.warn(ExceptionUtils.getMessage((Throwable)e));
            }
        }
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setRemoteClassLoadingDisabled(boolean disabled) {
        this.remoteClassLoadingDisabled.set(disabled);
        if (this.dynamic) {
            ((AbstractJPPFClassLoaderLifeCycle)this.getParent()).setRemoteClassLoadingDisabled(disabled);
        }
    }

    public boolean isRemoteClassLoadingDisabled() {
        return this.remoteClassLoadingDisabled.get() || this.isOffline();
    }

    public ResourceCache getResourceCache() {
        return this.resourceCache;
    }

    private static ResourceCache createResourceCache() {
        boolean enabled = (Boolean)JPPFConfiguration.get((JPPFProperty)JPPFProperties.RESOURCE_CACHE_ENABLED);
        return new ResourceCache(enabled);
    }
}

