/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.beans.Introspector;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.concurrent.ThreadPoolExecutor;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JPPFLeakPrevention {
    private static final Logger log = LoggerFactory.getLogger(JPPFLeakPrevention.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final String THREAD_GROUP_SYSTEM = "system";
    private static final String THREAD_GROUP_RMI_RUNTIME = "RMI Runtime";
    private final boolean preventJVM;
    private final boolean preventThread;
    private final boolean preventTimer;
    private final boolean preventThreadLocal;
    private final boolean preventKeepAlive;
    private final boolean preventStaticReferences;

    public JPPFLeakPrevention(TypedProperties config) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.preventJVM = config.getBoolean("jppf.classloader.clear.jvm", false);
        this.preventThread = config.getBoolean("jppf.classloader.clear.thread", false);
        this.preventTimer = config.getBoolean("jppf.classloader.clear.timer", false);
        this.preventThreadLocal = config.getBoolean("jppf.classloader.clear.thread.local", false);
        this.preventKeepAlive = config.getBoolean("jppf.classloader.clear.keep.alive", false);
        this.preventStaticReferences = config.getBoolean("jppf.classloader.clear.static", false);
    }

    public void clearReferences(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        try {
            if (this.preventJVM) {
                JPPFLeakPrevention.clearJDBCDrivers(classLoader);
            }
        }
        catch (Throwable t) {
            if (debugEnabled) {
                log.debug(t.getMessage(), t);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)t));
        }
        try {
            if (this.preventKeepAlive || this.preventTimer || this.preventThread) {
                this.clearThreads(classLoader);
            }
        }
        catch (Throwable t) {
            if (debugEnabled) {
                log.debug(t.getMessage(), t);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)t));
        }
        try {
            if (this.preventThreadLocal) {
                this.clearThreadLocal(classLoader);
            }
        }
        catch (Throwable t) {
            if (debugEnabled) {
                log.debug(t.getMessage(), t);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)t));
        }
        try {
            if (this.preventStaticReferences) {
                JPPFLeakPrevention.clearStaticFields(classLoader);
            }
        }
        catch (Throwable t) {
            if (debugEnabled) {
                log.debug(t.getMessage(), t);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)t));
        }
        try {
            if (this.preventJVM) {
                ResourceBundle.clearCache(classLoader);
            }
        }
        catch (Throwable t) {
            if (debugEnabled) {
                log.debug(t.getMessage(), t);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)t));
        }
        try {
            if (this.preventJVM) {
                Introspector.flushCaches();
            }
        }
        catch (Throwable t) {
            if (debugEnabled) {
                log.debug(t.getMessage(), t);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)t));
        }
    }

    private static void clearJDBCDrivers(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver.getClass().getClassLoader() != classLoader) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                    continue;
                }
                log.warn(ExceptionUtils.getMessage((Throwable)e));
            }
        }
    }

    private void clearThreads(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        for (Thread thread : JPPFLeakPrevention.getThreads()) {
            ClassLoader ccl;
            if (thread == null || (ccl = thread.getContextClassLoader()) != classLoader || thread == Thread.currentThread()) continue;
            ThreadGroup threadGroup = thread.getThreadGroup();
            if (threadGroup != null && (THREAD_GROUP_SYSTEM.equals(threadGroup.getName()) || THREAD_GROUP_RMI_RUNTIME.equals(threadGroup.getName()))) {
                if (!this.preventKeepAlive || !"Keep-Alive-Timer".equals(thread.getName())) continue;
                thread.setContextClassLoader(classLoader.getParent());
                log.warn("HTTP keep alive timer cleared");
                continue;
            }
            if (!thread.isAlive()) continue;
            if (this.preventTimer && "java.util.TimerThread".equals(thread.getClass().getName())) {
                JPPFLeakPrevention.clearTimerThread(thread);
                continue;
            }
            if (!this.preventThread) continue;
            try {
                Field fieldThis;
                Object executor;
                Class<?> clazz = thread.getClass();
                while (!Thread.class.equals(clazz)) {
                    clazz = clazz.getSuperclass();
                }
                Field fieldTarget = JPPFLeakPrevention.getDeclaredAccessibleField(clazz, "target");
                Object target = fieldTarget.get(thread);
                if (target != null && "java.util.concurrent.ThreadPoolExecutor.Worker".equals(target.getClass().getCanonicalName()) && (executor = (fieldThis = JPPFLeakPrevention.getDeclaredAccessibleField(target.getClass(), "this$0")).get(target)) instanceof ThreadPoolExecutor) {
                    ((ThreadPoolExecutor)executor).shutdownNow();
                }
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                log.warn(ExceptionUtils.getMessage((Throwable)e));
            }
            thread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearTimerThread(Thread thread) {
        try {
            Field fieldNewTasks = JPPFLeakPrevention.getDeclaredAccessibleField(thread.getClass(), "newTasksMayBeScheduled");
            Field fieldQueue = JPPFLeakPrevention.getDeclaredAccessibleField(thread.getClass(), "queue");
            Object queue = fieldQueue.get(thread);
            Method methodClear = JPPFLeakPrevention.getDeclaredAccessibleMethod(queue.getClass(), "clear");
            Object object = queue;
            synchronized (object) {
                fieldNewTasks.setBoolean(thread, false);
                methodClear.invoke(queue, new Object[0]);
                queue.notify();
            }
            log.warn("Timer thread " + thread.getName() + " leaked.");
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private void clearThreadLocal(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        try {
            Field fieldThreadLocals = JPPFLeakPrevention.getDeclaredAccessibleField(Thread.class, "threadLocals");
            Field fieldInheritableThreadLocals = JPPFLeakPrevention.getDeclaredAccessibleField(Thread.class, "inheritableThreadLocals");
            Field fieldTable = JPPFLeakPrevention.getDeclaredAccessibleField(Class.forName("java.lang.ThreadLocal$ThreadLocalMap"), "table");
            for (Thread thread : JPPFLeakPrevention.getThreads()) {
                if (thread == null) continue;
                this.clearThreadLocalMap(classLoader, fieldThreadLocals.get(thread), fieldTable);
                this.clearThreadLocalMap(classLoader, fieldInheritableThreadLocals.get(thread), fieldTable);
            }
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private void clearThreadLocalMap(ClassLoader classLoader, Object map, Field fieldTable) throws Exception {
        if (map == null) {
            return;
        }
        Method methodRemove = map.getClass().getDeclaredMethod("remove", ThreadLocal.class);
        methodRemove.setAccessible(true);
        Object[] table = (Object[])fieldTable.get(map);
        if (table != null) {
            StringBuilder sb = new StringBuilder();
            boolean hasStaleEntries = false;
            for (Object item : table) {
                if (item == null) continue;
                Object key = ((Reference)item).get();
                boolean remove = JPPFLeakPrevention.isLoadedByClassLoader(classLoader, key);
                Field fieldValue = JPPFLeakPrevention.getDeclaredAccessibleField(item.getClass(), "value");
                Object value = fieldValue.get(item);
                if (!(remove |= JPPFLeakPrevention.isLoadedByClassLoader(classLoader, value))) continue;
                sb.setLength(0);
                sb.append(classLoader.toString());
                sb.append(", ");
                if (key != null) {
                    sb.append(key.getClass().getName());
                    sb.append(", ");
                    try {
                        sb.append(key);
                    }
                    catch (Exception e) {
                        if (debugEnabled) {
                            log.debug("Clear thread local: key=" + sb + " - " + e.getMessage(), (Throwable)e);
                        } else {
                            log.warn("Clear thread local: key=" + sb + " - " + ExceptionUtils.getMessage((Throwable)e));
                        }
                        sb.append("???");
                    }
                } else {
                    sb.append("???, <null>");
                }
                sb.append(", ");
                if (value != null) {
                    sb.append(value.getClass().getName());
                    sb.append(", ");
                    try {
                        sb.append(value);
                    }
                    catch (Exception e) {
                        if (debugEnabled) {
                            log.debug("Clear thread local: value=" + sb + " - " + e.getMessage(), (Throwable)e);
                        } else {
                            log.warn("Clear thread local: value=" + sb + " - " + ExceptionUtils.getMessage((Throwable)e));
                        }
                        sb.append("???");
                    }
                } else {
                    sb.append("???, <null>");
                }
                if (debugEnabled) {
                    log.debug("Clear thread local: " + sb);
                }
                if (!this.preventThreadLocal) continue;
                if (key == null) {
                    hasStaleEntries = true;
                    continue;
                }
                methodRemove.invoke(map, key);
            }
            if (hasStaleEntries) {
                Method methodExpungeStaleEntries = JPPFLeakPrevention.getDeclaredAccessibleMethod(map.getClass(), "expungeStaleEntries");
                methodExpungeStaleEntries.invoke(map, new Object[0]);
            }
        }
    }

    private static void clearStaticFields(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        block6: for (Class<?> clazz : JPPFLeakPrevention.getLoadedClasses(classLoader)) {
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers())) continue;
                    field.get(null);
                    continue block6;
                }
            }
            catch (Throwable arr$) {
            }
        }
        for (Class<?> clazz : JPPFLeakPrevention.getLoadedClasses(classLoader)) {
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    int mods;
                    if (field.getType().isPrimitive() || field.getName().contains("$") || !Modifier.isStatic(mods = field.getModifiers())) continue;
                    try {
                        field.setAccessible(true);
                        if (Modifier.isFinal(mods)) {
                            if (field.getType().getName().startsWith("javax.") || field.getType().getName().startsWith("java.")) continue;
                            JPPFLeakPrevention.nullInstance(classLoader, field.get(null));
                            continue;
                        }
                        field.set(null, null);
                        if (!debugEnabled) continue;
                        log.debug("Set " + clazz.getName() + '.' + field.getName() + " to null");
                    }
                    catch (Throwable t) {
                        if (debugEnabled) {
                            log.debug(t.getMessage(), t);
                        } else {
                            log.warn(ExceptionUtils.getMessage((Throwable)t));
                        }
                        if (!debugEnabled) continue;
                        log.debug("Could not set " + clazz.getName() + '.' + field.getName() + " to null", t);
                    }
                }
            }
            catch (Throwable t) {
                if (debugEnabled) {
                    log.debug(t.getMessage(), t);
                } else {
                    log.warn(ExceptionUtils.getMessage((Throwable)t));
                }
                if (!debugEnabled) continue;
                log.debug("Could not clean fields for class " + clazz.getName(), t);
            }
        }
    }

    private static void nullInstance(ClassLoader classLoader, Object instance) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        if (instance == null) {
            return;
        }
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getName().contains("$")) continue;
            try {
                int mods = field.getModifiers();
                if (Modifier.isStatic(mods) && Modifier.isFinal(mods)) continue;
                field.setAccessible(true);
                Object value = field.get(instance);
                if (value == null || !JPPFLeakPrevention.isLoadedByClassLoader(classLoader, value.getClass())) continue;
                field.set(instance, null);
                if (!debugEnabled) continue;
                log.debug("Set " + instance.getClass().getName() + '.' + field.getName() + " to null");
            }
            catch (Throwable t) {
                if (!debugEnabled) continue;
                log.debug("Could not set " + instance.getClass().getName() + '.' + field.getName() + " to null", t);
            }
        }
    }

    private static Thread[] getThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread[] threads = new Thread[2 * threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        return threads;
    }

    private static Field getDeclaredAccessibleField(Class<?> clazz, String name) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is blank");
        }
        Field member = clazz.getDeclaredField(name);
        member.setAccessible(true);
        return member;
    }

    private static Method getDeclaredAccessibleMethod(Class<?> clazz, String name) throws NoSuchMethodException {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is blank");
        }
        Method member = clazz.getDeclaredMethod(name, new Class[0]);
        member.setAccessible(true);
        return member;
    }

    private static boolean isLoadedByClassLoader(ClassLoader classLoader, Object o) {
        return o != null && (classLoader.equals(o) || JPPFLeakPrevention.isLoadedByClassLoader(classLoader, o.getClass()));
    }

    private static boolean isLoadedByClassLoader(ClassLoader classLoader, Class<?> clazz) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        for (ClassLoader loader = clazz.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (classLoader != loader) continue;
            return true;
        }
        return false;
    }

    private static Collection<Class<?>> getLoadedClasses(ClassLoader classLoader) {
        Class<?> cls;
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        for (cls = classLoader.getClass(); cls != null && !ClassLoader.class.equals(cls); cls = cls.getSuperclass()) {
        }
        try {
            if (cls != null) {
                Field field = JPPFLeakPrevention.getDeclaredAccessibleField(cls, "classes");
                return Collections.unmodifiableCollection((Collection)field.get(classLoader));
            }
        }
        catch (Throwable t) {
            if (debugEnabled) {
                log.debug(t.getMessage(), t);
            }
            log.warn(ExceptionUtils.getMessage((Throwable)t));
        }
        return Collections.emptyList();
    }
}

