/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import org.jppf.classloader.AbstractResourceRequest;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.LocalClassLoaderChannel;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.StringUtils;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalResourceRequest
extends AbstractResourceRequest {
    private static Logger log = LoggerFactory.getLogger(LocalResourceRequest.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final LocalClassLoaderChannel channel;

    public LocalResourceRequest(LocalClassLoaderChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.throwable = null;
            if (debugEnabled) {
                log.debug(StringUtils.build((Object[])new Object[]{"channel ", this.channel, " sending request ", this.request}));
            }
            ThreadSynchronization threadSynchronization = this.channel.getServerLock();
            synchronized (threadSynchronization) {
                this.channel.setServerResource(this.request);
                this.channel.setReadyOps(1);
                while (this.channel.getServerResource() != null) {
                    this.channel.getServerLock().goToSleep();
                }
            }
            threadSynchronization = this.channel.getNodeLock();
            synchronized (threadSynchronization) {
                this.channel.setReadyOps(4);
                while ((this.response = (JPPFResourceWrapper)this.channel.getNodeResource()) == null) {
                    this.channel.getNodeLock().goToSleep();
                }
                this.channel.setNodeResource(null);
            }
            if (debugEnabled) {
                log.debug(StringUtils.build((Object[])new Object[]{"channel ", this.channel, " got response ", this.response}));
            }
        }
        catch (Throwable t) {
            this.throwable = t;
        }
    }
}

