/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader.resource;

import java.io.File;
import java.security.PrivilegedAction;
import java.util.List;
import org.jppf.location.FileLocation;
import org.jppf.location.Location;
import org.jppf.location.MemoryLocation;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;

public class SaveResourceAction
implements PrivilegedAction<Location<?>> {
    private static final boolean IS_MEMORY_STORAGE = SaveResourceAction.isMemoryStorageType();
    private List<String> tmpDirs = null;
    private String name = null;
    private final byte[] definition;
    private Exception exception = null;

    public SaveResourceAction(List<String> tmpDirs, String name, byte[] definition) {
        this.tmpDirs = tmpDirs;
        this.name = name;
        this.definition = definition;
    }

    @Override
    public Location<?> run() {
        Location<?> resource = null;
        if (!IS_MEMORY_STORAGE) {
            resource = this.saveToFileResource();
        }
        if (resource == null) {
            resource = this.saveToMemoryResource();
        }
        return resource;
    }

    private Location<?> saveToFileResource() {
        FileLocation resource;
        block4: {
            resource = null;
            File tmp = null;
            try {
                for (String s : this.tmpDirs) {
                    File f = new File(s, this.name);
                    if (f.exists()) continue;
                    tmp = f;
                    break;
                }
                if (tmp == null) {
                    String dir = this.tmpDirs.get(0) + '_' + this.tmpDirs.size();
                    File f = new File(dir + File.separator);
                    FileUtils.mkdirs((File)f);
                    f.deleteOnExit();
                    tmp = new File(f, this.name);
                    this.tmpDirs.add(dir);
                }
                FileUtils.mkdirs((File)tmp);
                tmp.deleteOnExit();
                FileUtils.writeBytesToFile((byte[])this.definition, (File)tmp);
                resource = new FileLocation(tmp);
                this.exception = null;
            }
            catch (Exception e) {
                this.exception = e;
                if (tmp == null || !tmp.exists()) break block4;
                tmp.delete();
                tmp = null;
            }
        }
        return resource;
    }

    private Location<?> saveToMemoryResource() {
        MemoryLocation resource = null;
        try {
            resource = new MemoryLocation(this.definition);
            this.exception = null;
        }
        catch (Exception e) {
            this.exception = e;
        }
        return resource;
    }

    public Exception getException() {
        return this.exception;
    }

    private static boolean isMemoryStorageType() {
        String s = (String)JPPFConfiguration.get((JPPFProperty)JPPFProperties.RESOURCE_CACHE_STORAGE);
        return "memory".equalsIgnoreCase(s);
    }
}

