/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node;

import org.jppf.management.JPPFNodeAdminMBean;
import org.jppf.process.LauncherListenerProtocolHandler;
import org.jppf.process.ProcessCommands;
import org.jppf.server.node.JPPFNode;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownRestartNodeProtocolHandler
implements LauncherListenerProtocolHandler {
    private static Logger log = LoggerFactory.getLogger(ShutdownRestartNodeProtocolHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final JPPFNode node;

    public ShutdownRestartNodeProtocolHandler(JPPFNode node) {
        this.node = node;
    }

    public void performAction(int actionCode) {
        if (this.node == null) {
            return;
        }
        JPPFNodeAdminMBean mbean = this.node.getNodeAdmin();
        if (mbean == null) {
            return;
        }
        try {
            if (debugEnabled) {
                log.debug("processing {} command code", (Object)ProcessCommands.getCommandName((int)actionCode));
            }
            switch (actionCode) {
                case 1: {
                    mbean.restart(Boolean.valueOf(true));
                    break;
                }
                case 2: {
                    mbean.restart(Boolean.valueOf(false));
                    break;
                }
                case 3: {
                    mbean.shutdown(Boolean.valueOf(true));
                    break;
                }
                case 4: {
                    mbean.shutdown(Boolean.valueOf(false));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

