/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.connection;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jppf.node.connection.ConnectionContext;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.node.connection.DriverConnectionInfo;
import org.jppf.node.connection.DriverConnectionStrategy;
import org.jppf.node.connection.JPPFDefaultConnectionStrategy;
import org.jppf.node.connection.JPPFDriverConnectionInfo;
import org.jppf.utils.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCsvConnectionStrategy
implements DriverConnectionStrategy {
    private static Logger log = LoggerFactory.getLogger(AbstractCsvConnectionStrategy.class);
    final Queue<DriverConnectionInfo> queue = new LinkedBlockingQueue<DriverConnectionInfo>();
    final DriverConnectionStrategy fallbackStrategy;

    public AbstractCsvConnectionStrategy() {
        this.readAllConnectionInfo();
        DriverConnectionStrategy driverConnectionStrategy = this.fallbackStrategy = this.queue.isEmpty() ? new JPPFDefaultConnectionStrategy() : null;
        if (log.isDebugEnabled()) {
            if (this.queue.isEmpty()) {
                log.debug("no valid driver definition found, falling back to default strategy");
            } else {
                StringBuilder sb = new StringBuilder("driver definitions:");
                for (DriverConnectionInfo info : this.queue) {
                    sb.append('\n').append(info);
                }
                log.debug(sb.toString());
            }
        }
    }

    @Override
    public DriverConnectionInfo nextConnectionInfo(DriverConnectionInfo currentInfo, ConnectionContext context) {
        if (this.fallbackStrategy != null) {
            return this.fallbackStrategy.nextConnectionInfo(currentInfo, context);
        }
        if (log.isDebugEnabled()) {
            log.debug("new connection request with prevInfo={} and context={}", (Object)currentInfo, (Object)context);
        }
        if (currentInfo != null && context.getReason() == ConnectionReason.MANAGEMENT_REQUEST) {
            return currentInfo;
        }
        DriverConnectionInfo info = this.queue.poll();
        this.queue.offer(info);
        return info;
    }

    void readAllConnectionInfo() {
        try {
            List<String> lines = this.getConnectionInfoAsLines();
            for (String line : lines) {
                DriverConnectionInfo info = AbstractCsvConnectionStrategy.parseLine(line.trim());
                if (info == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("got connection info: {}", (Object)info);
                }
                this.queue.offer(info);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    abstract List<String> getConnectionInfoAsLines();

    static DriverConnectionInfo parseLine(String csv) {
        if (csv.startsWith("#")) {
            return null;
        }
        String[] tokens = RegexUtils.COMMA_PATTERN.split(csv);
        if (tokens != null && tokens.length == 4) {
            int port;
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = tokens[i].trim();
            }
            boolean secure = "true".equalsIgnoreCase(tokens[0]);
            String host = tokens[1];
            boolean recoveryEnabled = false;
            try {
                port = Integer.valueOf(tokens[2]);
            }
            catch (Exception e) {
                return null;
            }
            try {
                int recoveryPort = Integer.valueOf(tokens[3]);
                recoveryEnabled = recoveryPort > 0;
            }
            catch (Exception e) {
                recoveryEnabled = Boolean.valueOf(tokens[3]);
            }
            return new JPPFDriverConnectionInfo(secure, host, port, recoveryEnabled);
        }
        return null;
    }
}

