/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.connection;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jppf.node.connection.AbstractCsvConnectionStrategy;
import org.jppf.utils.JPPFConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFCsvPropertyConnectionStrategy
extends AbstractCsvConnectionStrategy {
    private static Logger log = LoggerFactory.getLogger(JPPFCsvPropertyConnectionStrategy.class);

    @Override
    List<String> getConnectionInfoAsLines() {
        try {
            String[] lines;
            String content = JPPFConfiguration.getProperties().getString("jppf.server.connection.strategy.definitions");
            if (content != null && !(content = content.trim()).isEmpty() && (lines = content.split("\\|")) != null && lines.length > 0) {
                List<String> result = Arrays.asList(lines);
                if (log.isDebugEnabled()) {
                    log.debug("found connection definitions in the configuration: {}", result);
                }
                return result;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }
}

