/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.connection;

import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.discovery.JPPFMulticastReceiver;
import org.jppf.node.connection.ConnectionContext;
import org.jppf.node.connection.DriverConnectionInfo;
import org.jppf.node.connection.DriverConnectionStrategy;
import org.jppf.node.connection.JPPFDriverConnectionInfo;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFDefaultConnectionStrategy
implements DriverConnectionStrategy {
    private static Logger log = LoggerFactory.getLogger(JPPFDefaultConnectionStrategy.class);

    @Override
    public DriverConnectionInfo nextConnectionInfo(DriverConnectionInfo currentInfo, ConnectionContext context) {
        return (Boolean)JPPFConfiguration.get((JPPFProperty)JPPFProperties.DISCOVERY_ENABLED) != false ? JPPFDefaultConnectionStrategy.discoverDriver() : JPPFDefaultConnectionStrategy.connectionFromManualConfiguration();
    }

    private static DriverConnectionInfo discoverDriver() {
        TypedProperties config = JPPFConfiguration.getProperties();
        JPPFMulticastReceiver receiver = new JPPFMulticastReceiver(new IPFilter(config));
        JPPFConnectionInformation info = receiver.receive();
        receiver.setStopped(true);
        if (info == null) {
            if (log.isDebugEnabled()) {
                log.debug("Could not auto-discover the driver connection information");
            }
            return JPPFDefaultConnectionStrategy.connectionFromManualConfiguration();
        }
        if (log.isDebugEnabled()) {
            log.debug("Discovered driver: " + info);
        }
        boolean ssl = (Boolean)config.get(JPPFProperties.SSL_ENABLED);
        boolean recovery = (Boolean)config.get(JPPFProperties.RECOVERY_ENABLED);
        return JPPFDriverConnectionInfo.fromJPPFConnectionInformation(info, ssl, recovery);
    }

    private static DriverConnectionInfo connectionFromManualConfiguration() {
        TypedProperties config = JPPFConfiguration.getProperties();
        boolean ssl = (Boolean)config.get(JPPFProperties.SSL_ENABLED);
        String host = (String)config.get(JPPFProperties.SERVER_HOST);
        int port = (Integer)config.get(ssl ? JPPFProperties.SERVER_SSL_PORT_NODE : JPPFProperties.SERVER_PORT);
        return new JPPFDriverConnectionInfo(ssl, host, port, (Boolean)config.get(JPPFProperties.RECOVERY_ENABLED));
    }
}

