/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.connection;

import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.node.connection.DriverConnectionInfo;

public class JPPFDriverConnectionInfo
implements DriverConnectionInfo {
    protected final boolean secure;
    protected final String host;
    protected final int port;
    protected final boolean recoveryEnabled;

    public JPPFDriverConnectionInfo(boolean secure, String host, int port, int recoveryPort) {
        this(secure, host, port, recoveryPort > 0);
    }

    public JPPFDriverConnectionInfo(boolean secure, String host, int port, boolean recoveryEnabled) {
        this.secure = secure;
        this.host = host;
        this.port = port;
        this.recoveryEnabled = recoveryEnabled;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getRecoveryPort() {
        return this.recoveryEnabled ? this.port : -1;
    }

    @Override
    public boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.recoveryEnabled ? 1 : 0);
        result = 31 * result + (this.secure ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JPPFDriverConnectionInfo other = (JPPFDriverConnectionInfo)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.recoveryEnabled != other.recoveryEnabled) {
            return false;
        }
        return this.secure == other.secure;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("secure=").append(this.secure);
        sb.append(", host=").append(this.host);
        sb.append(", port=").append(this.port);
        sb.append(", recoveryEnabled=").append(this.recoveryEnabled);
        sb.append(']');
        return sb.toString();
    }

    public static DriverConnectionInfo fromJPPFConnectionInformation(JPPFConnectionInformation ci, boolean ssl, boolean recovery) {
        int port = ssl ? ci.sslServerPorts[0] : ci.serverPorts[0];
        return new JPPFDriverConnectionInfo(ssl, ci.host, port, ci.recoveryEnabled);
    }
}

