/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.debug;

import org.jppf.node.NodeRunner;
import org.jppf.node.debug.NodeDebugMBean;
import org.jppf.scripting.JPPFScriptingException;
import org.jppf.scripting.ScriptDefinition;
import org.jppf.server.node.JPPFNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDebug
implements NodeDebugMBean {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(NodeDebug.class);

    @Override
    public void log(String ... messages) {
        if (messages != null) {
            for (String message : messages) {
                log.info(message);
            }
        }
    }

    @Override
    public void cancel() {
        JPPFNode node = (JPPFNode)NodeRunner.getNode();
        node.getExecutionManager().cancelAllTasks(true, false);
    }

    @Override
    public Object executeScript(String language, String script) throws JPPFScriptingException {
        if (log.isTraceEnabled()) {
            log.trace(String.format("request to execute %s script:%n%s", language, script));
        }
        return new ScriptDefinition(language, script).evaluate();
    }
}

