/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.event;

import java.io.File;
import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.location.FileLocation;
import org.jppf.location.Location;
import org.jppf.location.MemoryLocation;
import org.jppf.location.URLLocation;
import org.jppf.node.Node;
import org.jppf.node.event.NodeLifeCycleEvent;
import org.jppf.node.event.NodeLifeCycleListenerAdapter;
import org.jppf.node.protocol.ClassPath;
import org.jppf.node.protocol.ClassPathElement;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClassPathHandler
extends NodeLifeCycleListenerAdapter {
    private static final Logger log = LoggerFactory.getLogger(JobClassPathHandler.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final AtomicLong SEQUENCE = new AtomicLong(0L);

    @Override
    public void jobHeaderLoaded(NodeLifeCycleEvent event) {
        ClassPath classpath = event.getJob().getSLA().getClassPath();
        if (classpath == null) {
            return;
        }
        Node node = event.getNode();
        if (node.isAndroid()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace(StringUtils.printClassLoaderHierarchy((ClassLoader)event.getTaskClassLoader()));
        }
        AbstractJPPFClassLoader cl = event.getTaskClassLoader();
        if (classpath.isForceClassLoaderReset() || !classpath.isEmpty()) {
            cl = (AbstractJPPFClassLoader)node.resetTaskClassLoader(new Object[0]);
        }
        if (!classpath.isEmpty()) {
            for (ClassPathElement elt : classpath) {
                boolean validated = false;
                try {
                    validated = elt.validate();
                }
                catch (Throwable t) {
                    String format = "exception occurred during validation of classpath element '{}' : {}";
                    if (debugEnabled) {
                        log.debug("exception occurred during validation of classpath element '{}' : {}", (Object)elt, (Object)ExceptionUtils.getStackTrace((Throwable)t));
                    }
                    log.warn("exception occurred during validation of classpath element '{}' : {}", (Object)elt, (Object)ExceptionUtils.getMessage((Throwable)t));
                }
                if (!validated) continue;
                URL url = null;
                Location source = elt.getSourceLocation();
                Location target = elt.getTargetLocation();
                if (debugEnabled) {
                    log.debug("processing classpath element with [source = {}; target = {}]", (Object)source, (Object)target);
                }
                try {
                    String path;
                    if (target != source && ((path = JobClassPathHandler.getFilePath(target)) == null || elt.isCopyToExistingFile() || !new File(path).exists())) {
                        if (debugEnabled) {
                            log.debug("copying {} to {}", (Object)source, (Object)target);
                        }
                        source.copyTo(target);
                    }
                    if (target instanceof MemoryLocation) {
                        String name = Long.toString(SEQUENCE.incrementAndGet());
                        cl.getResourceCache().registerResource(name, target);
                        url = cl.getResourceCache().getResourceURL(name);
                    } else if (target instanceof FileLocation) {
                        File file = new File((String)((FileLocation)target).getPath());
                        if (file.exists()) {
                            url = file.toURI().toURL();
                        }
                    } else if (target instanceof URLLocation) {
                        url = (URL)((URLLocation)target).getPath();
                    }
                }
                catch (Exception e) {
                    String format = "exception occurred during processing of classpath element '{}' : {}";
                    if (debugEnabled) {
                        log.debug("exception occurred during processing of classpath element '{}' : {}", (Object)elt, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    }
                    log.warn("exception occurred during processing of classpath element '{}' : {}", (Object)elt, (Object)ExceptionUtils.getMessage((Throwable)e));
                }
                if (url == null) continue;
                cl.addURL(url);
            }
        }
    }

    private static String getFilePath(Location<?> location) {
        URL url;
        if (location instanceof FileLocation) {
            return (String)((FileLocation)location).getPath();
        }
        if (location instanceof URLLocation && "file".equalsIgnoreCase((url = (URL)((URLLocation)location).getPath()).getProtocol())) {
            return url.getPath();
        }
        return null;
    }
}

