/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.idle;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.X11;
import java.util.Arrays;
import java.util.List;
import org.jppf.JPPFError;
import org.jppf.node.idle.IdleTimeDetector;

class X11IdleTimeDetector
implements IdleTimeDetector {
    X11IdleTimeDetector() {
    }

    public long getIdleTimeMillis() {
        X11.Window window = null;
        XScreenSaverInfo info = null;
        X11.Display display = null;
        long idleMillis = 0L;
        try {
            display = X11.INSTANCE.XOpenDisplay(null);
            if (display == null) {
                display = X11.INSTANCE.XOpenDisplay(":0.0");
            }
            if (display == null) {
                throw new JPPFError("Could not find a display, please setup your DISPLAY environment variable");
            }
            window = X11.INSTANCE.XDefaultRootWindow(display);
            info = new XScreenSaverInfo();
            Xss.INSTANCE.XScreenSaverQueryInfo(display, (X11.Drawable)window, info);
            idleMillis = info.idle.longValue();
        }
        catch (UnsatisfiedLinkError e) {
            throw new JPPFError(e.getMessage(), (Throwable)e);
        }
        finally {
            info = null;
            if (display != null) {
                X11.INSTANCE.XCloseDisplay(display);
            }
            display = null;
        }
        return idleMillis;
    }

    public static interface Xss
    extends Library {
        public static final Xss INSTANCE = (Xss)Native.loadLibrary((String)"Xss", Xss.class);

        public XScreenSaverInfo XScreenSaverAllocInfo();

        public int XScreenSaverQueryInfo(X11.Display var1, X11.Drawable var2, XScreenSaverInfo var3);
    }

    public static class XScreenSaverInfo
    extends Structure {
        public X11.Window window;
        public int state;
        public int kind;
        public NativeLong til_or_since;
        public NativeLong idle;
        public NativeLong event_mask;

        protected List<String> getFieldOrder() {
            return Arrays.asList("window", "state", "kind", "til_or_since", "idle", "event_mask");
        }
    }
}

