/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.initialization;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.jppf.node.initialization.InitializationHook;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.UnmodifiableTypedProperties;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputRedirectHook
implements InitializationHook {
    private static Logger log = LoggerFactory.getLogger(OutputRedirectHook.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    @Override
    public void initializing(UnmodifiableTypedProperties config) {
        OutputRedirectHook.handleStream(config, true);
        OutputRedirectHook.handleStream(config, false);
    }

    private static void handleStream(UnmodifiableTypedProperties config, boolean isOut) {
        try {
            JPPFProperty pathProp = isOut ? JPPFProperties.REDIRECT_OUT : JPPFProperties.REDIRECT_ERR;
            File outFile = (File)config.get(pathProp);
            if (outFile == null) {
                return;
            }
            if (debugEnabled) {
                log.debug("redirecting System.{} to file {}", (Object)(isOut ? "out" : "err"), (Object)outFile);
            }
            JPPFProperty appendProp = isOut ? JPPFProperties.REDIRECT_OUT_APPEND : JPPFProperties.REDIRECT_ERR_APPEND;
            boolean append = (Boolean)config.get(appendProp);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile, append));
            PrintStream pos = new PrintStream(os, true);
            pos.println("********** " + new Date() + " **********");
            if (isOut) {
                System.setOut(pos);
            } else {
                System.setErr(pos);
            }
        }
        catch (Exception e) {
            String message = "error occurred while trying to redirect System." + (isOut ? "out" : "err") + " : {}";
            if (debugEnabled) {
                log.debug(message, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            log.warn(message, (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }
}

