/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.provisioning;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jppf.process.AbstractProcessLauncher;
import org.jppf.utils.Pair;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlaveNodeLauncher
extends AbstractProcessLauncher {
    private static final String MAIN_CLASS = "org.jppf.node.NodeRunner";
    private static Logger log = LoggerFactory.getLogger(SlaveNodeLauncher.class);
    static final String SLAVE_LOCAL_CONFIG_PATH = "config/jppf-node.properties";
    private final int id;
    private final File slaveDir;
    private final List<String> classpath;
    private boolean started = false;
    int exitCode = -1;

    public SlaveNodeLauncher(int id, String name, List<String> classpath) {
        this.id = id;
        this.name = name;
        this.classpath = classpath;
        this.slaveDir = new File(name);
        if (log.isDebugEnabled()) {
            log.debug("slaveDir = " + this.slaveDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread hookThread = null;
        try {
            hookThread = this.createShutdownHook();
            this.startSocketListener();
            SlaveNodeLauncher slaveNodeLauncher = this;
            synchronized (slaveNodeLauncher) {
                block19: {
                    if (!this.isStopped()) break block19;
                    return;
                }
                this.process = this.startProcess();
                this.setStarted(true);
                this.fireProcessStarted();
            }
            this.exitCode = this.process.waitFor();
            this.end = this.onProcessExit(this.exitCode);
            this.fireProcessStopped(false);
            this.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fireProcessStopped(false);
        }
        finally {
            this.setStarted(false);
            try {
                if (hookThread != null) {
                    Runtime.getRuntime().removeShutdownHook(hookThread);
                }
            }
            catch (Exception exception) {}
        }
    }

    private Process startProcess() throws Exception {
        File configFile = new File(this.slaveDir, SLAVE_LOCAL_CONFIG_PATH);
        TypedProperties config = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            config = (TypedProperties)new TypedProperties().loadAndResolve((Reader)reader);
        }
        if (log.isDebugEnabled()) {
            log.debug("{} read config {} : {}", new Object[]{this.name, configFile, config});
        }
        ArrayList jvmOptions = new ArrayList();
        ArrayList<String> cpElements = new ArrayList<String>(this.classpath);
        String s = (String)config.get(JPPFProperties.JVM_OPTIONS);
        Pair parsed = this.parseJvmOptions(s);
        jvmOptions.addAll((Collection)parsed.first());
        cpElements.addAll((Collection)parsed.second());
        s = (String)config.get(JPPFProperties.PROVISIONING_SLAVE_JVM_OPTIONS);
        parsed = this.parseJvmOptions(s);
        jvmOptions.addAll((Collection)parsed.first());
        cpElements.addAll((Collection)parsed.second());
        if (log.isDebugEnabled()) {
            log.debug("JVM options: " + jvmOptions);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.computeJavaExecPath(config));
        command.add("-cp");
        command.add(this.buildClasspath(cpElements));
        for (String opt : jvmOptions) {
            command.add(opt);
        }
        command.add("-Djppf.config=config/jppf-node.properties");
        command.add(MAIN_CLASS);
        command.add("" + this.processPort);
        if (log.isDebugEnabled()) {
            log.debug("process command for {}:\n{}", (Object)this.name, command);
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(this.slaveDir);
        builder.redirectOutput(new File(this.slaveDir, "system_out.log"));
        builder.redirectError(new File(this.slaveDir, "system_err.log"));
        return builder.start();
    }

    protected boolean onProcessExit(int n) {
        return n != 2;
    }

    public int getId() {
        return this.id;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void setStarted(boolean started) {
        this.started = started;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }
}

