/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.screensaver;

import org.jppf.node.NodeInternal;
import org.jppf.node.event.NodeLifeCycleEvent;
import org.jppf.node.event.NodeLifeCycleListenerAdapter;
import org.jppf.node.event.TaskExecutionListener;
import org.jppf.node.screensaver.NodeIntegration;
import org.jppf.node.screensaver.ScreenSaverMain;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperties;

public class DelegatingNodeListener
extends NodeLifeCycleListenerAdapter {
    private NodeIntegration delegate;

    public DelegatingNodeListener() {
        try {
            TypedProperties config;
            String name;
            ScreenSaverMain ssm = ScreenSaverMain.getInstance();
            if (ssm != null && (name = (String)(config = ssm.getConfig()).get(JPPFProperties.SCREENSAVER_NODE_LISTENER)) != null) {
                Class<?> clazz = Class.forName(name, true, this.getClass().getClassLoader());
                this.delegate = (NodeIntegration)clazz.newInstance();
                this.delegate.setUiComponent(ssm.getScreenSaver());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void nodeStarting(NodeLifeCycleEvent event) {
        if (this.delegate != null) {
            ((NodeInternal)event.getNode()).getExecutionManager().getTaskNotificationDispatcher().addTaskExecutionListener((TaskExecutionListener)this.delegate);
            this.delegate.nodeStarting(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeEnding(NodeLifeCycleEvent event) {
        if (this.delegate != null) {
            try {
                this.delegate.nodeEnding(event);
            }
            finally {
                ((NodeInternal)event.getNode()).getExecutionManager().getTaskNotificationDispatcher().removeTaskExecutionListener((TaskExecutionListener)this.delegate);
            }
        }
    }

    @Override
    public void jobHeaderLoaded(NodeLifeCycleEvent event) {
        if (this.delegate != null) {
            this.delegate.jobHeaderLoaded(event);
        }
    }

    @Override
    public void jobStarting(NodeLifeCycleEvent event) {
        if (this.delegate != null) {
            this.delegate.jobStarting(event);
        }
    }

    @Override
    public void jobEnding(NodeLifeCycleEvent event) {
        if (this.delegate != null) {
            this.delegate.jobEnding(event);
        }
    }
}

