/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.screensaver.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.jppf.node.screensaver.JPPFScreenSaver;
import org.jppf.node.screensaver.ScreenSaverMain;
import org.jppf.node.screensaver.impl.ImageData;
import org.jppf.node.screensaver.impl.NodePanel;
import org.jppf.utils.RegexUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperties;

public class JPPFScreenSaverImpl
extends JPanel
implements JPPFScreenSaver {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SPEED = 100;
    private NodePanel nodePanel = null;
    private int nbLogos = 10;
    private ImageIcon[] logos = null;
    private int speed = 10;
    private boolean collisions = false;
    private ImageData[] data = null;
    private Timer timer = null;
    private int alignment = 1;
    private TypedProperties config;

    public JPPFScreenSaverImpl() {
        super(true);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void init(TypedProperties config, boolean fullscreen) {
        this.config = new TypedProperties((Map)config);
        this.configure();
        this.data = new ImageData[this.nbLogos];
        for (int i = 0; i < this.nbLogos; ++i) {
            this.data[i] = new ImageData(this.logos[i % this.logos.length]);
        }
        Dimension dim = this.getSize();
        for (ImageData d : this.data) {
            d.init(dim);
        }
        if (this.nodePanel == null) {
            this.nodePanel = this.createNodePanel();
        }
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.add(this.nodePanel);
        this.setBackground(Color.BLACK);
        Dimension dim2 = this.nodePanel.getPreferredSize();
        int hmargin = (this.getWidth() - dim2.width) / 2;
        int vmargin = (this.getHeight() - dim2.height) / 2;
        layout.putConstraint("West", (Component)this.nodePanel, this.alignment * hmargin, "West", (Component)this);
        layout.putConstraint("North", (Component)this.nodePanel, vmargin, "North", (Component)this);
        if (this.timer == null) {
            this.timer = new Timer("JPPFScreenSaverTimer");
            this.timer.schedule((TimerTask)new LogoUpdateTask(), 100L, 1000L / (long)this.speed);
            this.timer.schedule((TimerTask)new LogoPaintTask(), 100L, 20L);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (JPPFScreenSaverImpl.this.nodePanel != null) {
                        JPPFScreenSaverImpl.this.nodePanel.updateTimeLabel();
                    }
                }
            };
            this.timer.scheduleAtFixedRate(task, 1000L, 1000L);
        }
    }

    private void configure() {
        this.collisions = (Boolean)this.config.get(JPPFProperties.SCREENSAVER_HANDLE_COLLISIONS);
        this.nbLogos = (Integer)this.config.get(JPPFProperties.SCREENSAVER_LOGOS);
        this.speed = (Integer)this.config.get(JPPFProperties.SCREENSAVER_SPEED);
        if (this.speed < 1) {
            this.speed = 1;
        }
        if (this.speed > 100) {
            this.speed = 100;
        }
        String paths = (String)this.config.get(JPPFProperties.SCREENSAVER_LOGO_PATH);
        String[] tokens = RegexUtils.PIPE_PATTERN.split(paths);
        LinkedList<ImageIcon> list = new LinkedList<ImageIcon>();
        for (String s : tokens) {
            ImageIcon icon = ScreenSaverMain.loadImage(s.trim());
            if (icon == null) continue;
            list.add(icon);
        }
        if (list.isEmpty()) {
            list.add(ScreenSaverMain.loadImage((String)JPPFProperties.SCREENSAVER_LOGO_PATH.getDefaultValue()));
        }
        this.logos = new ImageIcon[list.size()];
        Random rnd = new Random(System.nanoTime());
        int count = 0;
        while (!list.isEmpty()) {
            int n = rnd.nextInt(list.size());
            this.logos[count++] = (ImageIcon)list.remove(n);
        }
        String s = ((String)this.config.get(JPPFProperties.SCREENSAVER_STATUS_PANEL_ALIGNMENT)).trim().toLowerCase();
        this.alignment = s.startsWith("l") ? 0 : (s.startsWith("r") ? 2 : 1);
    }

    @Override
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.nodePanel != null) {
            this.nodePanel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLogos(Graphics g) {
        if (this.data == null) {
            return;
        }
        Rectangle r = g.getClipBounds();
        try {
            ImageData[] arr$ = this.data;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ImageData d;
                ImageData imageData = d = arr$[i$];
                synchronized (imageData) {
                    g.setClip(d.x, d.y, d.imgw, d.imgh);
                    g.drawImage(d.img, d.x, d.y, null);
                    d.prevx = d.x;
                    d.prevy = d.y;
                    continue;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            g.setClip(r);
        }
    }

    protected NodePanel createNodePanel() {
        return new NodePanel();
    }

    public NodePanel getNodePanel() {
        return this.nodePanel;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintLogos(g);
    }

    public Timer getTimer() {
        return this.timer;
    }

    private class LogoUpdateTask
    extends TimerTask {
        private LogoUpdateTask() {
        }

        @Override
        public void run() {
            if (JPPFScreenSaverImpl.this.data == null) {
                return;
            }
            try {
                Dimension dim = JPPFScreenSaverImpl.this.getSize();
                for (int i = 0; i < JPPFScreenSaverImpl.this.data.length; ++i) {
                    ImageData d = JPPFScreenSaverImpl.this.data[i];
                    d.update(dim, JPPFScreenSaverImpl.this.collisions ? JPPFScreenSaverImpl.this.data : null, i + 1);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private class LogoPaintTask
    extends TimerTask {
        private LogoPaintTask() {
        }

        @Override
        public void run() {
            JPPFScreenSaverImpl.this.repaint();
        }
    }
}

