/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.server.node.JPPFContainer;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassLoaderManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractClassLoaderManager.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final int maxContainers;
    private AbstractJPPFClassLoader classLoader = null;
    private final Map<String, JPPFContainer> containerMap = new HashMap<String, JPPFContainer>();
    private final LinkedList<JPPFContainer> containerList = new LinkedList();

    protected AbstractClassLoaderManager() {
        TypedProperties config = JPPFConfiguration.getProperties();
        this.maxContainers = (Integer)config.get(JPPFProperties.CLASSLOADER_CACHE_SIZE);
    }

    public synchronized AbstractJPPFClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.createClassLoader();
            if (debugEnabled) {
                log.debug("created class loader " + this.classLoader);
            }
        }
        return this.classLoader;
    }

    protected abstract AbstractJPPFClassLoader createClassLoader();

    public synchronized void setClassLoader(AbstractJPPFClassLoader cl) {
        this.classLoader = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeClassLoader() {
        if (this.classLoader != null) {
            try {
                this.classLoader.close();
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            finally {
                this.classLoader = null;
            }
        }
    }

    public JPPFContainer getContainer(List<String> uuidPath, Object ... params) throws Exception {
        return this.getContainer(uuidPath, true, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JPPFContainer getContainer(List<String> uuidPath, boolean clientAccess, Object ... params) throws Exception {
        String uuid = uuidPath.get(0);
        JPPFContainer container = this.containerMap.get(uuid);
        if (container == null) {
            if (debugEnabled) {
                log.debug("Creating new container for appuuid=" + uuid);
            }
            AbstractJPPFClassLoader cl = this.newClientClassLoader(uuidPath, params);
            container = this.newJPPFContainer(uuidPath, cl, clientAccess);
            if (this.containerList.size() >= this.maxContainers) {
                JPPFContainer toRemove = this.containerList.removeFirst();
                try {
                    this.clearContainer(toRemove);
                }
                finally {
                    toRemove.helper = null;
                    toRemove.classLoader = null;
                    this.containerMap.remove(toRemove.getAppUuid());
                }
            }
            this.containerList.add(container);
            this.containerMap.put(uuid, container);
        }
        return container;
    }

    protected AbstractJPPFClassLoader newClientClassLoader(final List<String> uuidPath, final Object ... params) {
        return AccessController.doPrivileged(new PrivilegedAction<AbstractJPPFClassLoader>(){

            @Override
            public AbstractJPPFClassLoader run() {
                try {
                    return AbstractClassLoaderManager.this.newClassLoaderCreator(uuidPath, params).call();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearContainers() {
        this.closeClassLoader();
        try {
            for (JPPFContainer container : this.containerList) {
                this.clearContainer(container);
            }
        }
        finally {
            this.containerMap.clear();
            this.containerList.clear();
        }
    }

    protected void clearContainer(JPPFContainer container) {
        AbstractJPPFClassLoader loader = container.getClassLoader();
        if (loader != null) {
            loader.close();
        }
    }

    protected abstract JPPFContainer newJPPFContainer(List<String> var1, AbstractJPPFClassLoader var2, boolean var3) throws Exception;

    protected abstract Callable<AbstractJPPFClassLoader> newClassLoaderCreator(List<String> var1, Object ... var2);

    public void clearResourceCaches() {
        for (JPPFContainer cont : this.containerList) {
            AbstractJPPFClassLoader cl = cont.getClassLoader();
            if (cl == null) continue;
            cl.resetResourceCache();
        }
        if (this.classLoader != null) {
            this.classLoader.resetResourceCache();
        }
    }

    public AbstractJPPFClassLoader resetClassLoader(List<String> uuidPath, Object ... params) throws Exception {
        JPPFContainer cont = this.getContainer(uuidPath, new Object[0]);
        AbstractJPPFClassLoader oldCL = cont.getClassLoader();
        String requestUuid = oldCL.getRequestUuid();
        AbstractJPPFClassLoader newCL = this.newClientClassLoader(cont.uuidPath, params);
        newCL.setRequestUuid(requestUuid);
        cont.setClassLoader(newCL);
        oldCL.close();
        return newCL;
    }
}

