/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.serialization.SerializationHelper;
import org.jppf.server.node.SerializationExceptionHook;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.jppf.utils.hooks.HookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JPPFContainer {
    private static Logger log = LoggerFactory.getLogger(JPPFContainer.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static boolean traceEnabled = log.isTraceEnabled();
    protected SerializationHelper helper = null;
    protected ObjectSerializer serializer = null;
    protected AbstractJPPFClassLoader classLoader = null;
    protected List<String> uuidPath = new ArrayList<String>();
    private Lock lock = new ReentrantLock();
    private final boolean sequentialDeserialization = (Boolean)JPPFConfiguration.get((JPPFProperty)JPPFProperties.SEQUENTIAL_SERIALiZATION);
    private final boolean clientAccess;

    public JPPFContainer(List<String> uuidPath, AbstractJPPFClassLoader classLoader, boolean clientAccess) throws Exception {
        if (debugEnabled) {
            log.debug("new JPPFContainer with uuidPath={}, classLoader={}, clientAccess={}", new Object[]{uuidPath, classLoader, clientAccess});
        }
        this.uuidPath = uuidPath;
        this.classLoader = classLoader;
        this.clientAccess = clientAccess;
        this.init();
    }

    public final void init() throws Exception {
        this.initHelper();
    }

    public abstract int deserializeObjects(Object[] var1, int var2, ExecutorService var3) throws Throwable;

    public AbstractJPPFClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(AbstractJPPFClassLoader classLoader) {
        this.classLoader = classLoader;
        try {
            this.initHelper();
        }
        catch (Exception e) {
            log.error("error setting new class loader", (Throwable)e);
        }
    }

    protected void initHelper() throws Exception {
        AbstractJPPFClassLoader cl = this.getClassLoader();
        if (!this.clientAccess) {
            cl = (AbstractJPPFClassLoader)cl.getParent();
        }
        String name = "org.jppf.utils.SerializationHelperImpl";
        if (debugEnabled) {
            log.debug("loading class {} with classloader {}", (Object)"org.jppf.utils.SerializationHelperImpl", (Object)cl);
        }
        Class<?> c = cl.loadJPPFClass("org.jppf.utils.SerializationHelperImpl");
        this.helper = (SerializationHelper)c.newInstance();
        this.serializer = this.helper.getSerializer();
    }

    public String getAppUuid() {
        return this.uuidPath.isEmpty() ? null : this.uuidPath.get(0);
    }

    public void setUuidPath(List<String> uuidPath) {
        this.uuidPath = uuidPath;
    }

    public ObjectSerializer getSerializer() {
        return this.serializer;
    }

    protected class ObjectDeserializationTask
    implements Callable<ObjectDeserializationTask> {
        private final DataLocation dl;
        private final int index;
        private Object object;

        public ObjectDeserializationTask(DataLocation dl, int index) {
            this.dl = dl;
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectDeserializationTask call() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(JPPFContainer.this.getClassLoader());
                if (traceEnabled) {
                    log.debug("deserializing object index = " + this.index);
                }
                if (JPPFContainer.this.sequentialDeserialization) {
                    JPPFContainer.this.lock.lock();
                }
                try {
                    this.object = IOHelper.unwrappedData((DataLocation)this.dl, (ObjectSerializer)JPPFContainer.this.serializer);
                }
                finally {
                    if (JPPFContainer.this.sequentialDeserialization) {
                        JPPFContainer.this.lock.unlock();
                    }
                }
            }
            catch (Throwable t) {
                String desc = (this.index == 0 ? "data provider" : "task at index " + this.index) + " could not be deserialized";
                if (debugEnabled) {
                    log.debug("{} : {}", (Object)desc, (Object)ExceptionUtils.getStackTrace((Throwable)t));
                } else {
                    log.error("{} : {}", (Object)desc, (Object)ExceptionUtils.getMessage((Throwable)t));
                }
                if (this.index > 0) {
                    this.object = HookFactory.invokeSingleHook(SerializationExceptionHook.class, (String)"buildExceptionResult", (Object[])new Object[]{desc, t});
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            return this;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

