/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.util.ArrayList;
import java.util.List;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.execute.AbstractExecutionManager;
import org.jppf.execute.NodeTaskWrapper;
import org.jppf.management.NodeConfigNotifier;
import org.jppf.node.NodeInternal;
import org.jppf.node.event.LifeCycleEventHandler;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.JPPFTaskSerializationException;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.node.ClassLoaderProvider;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeExecutionManager
extends AbstractExecutionManager {
    private static final Logger log = LoggerFactory.getLogger(NodeExecutionManager.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final NodeInternal node;

    public NodeExecutionManager(NodeInternal node) {
        this(node, (JPPFProperty<Integer>)JPPFProperties.PROCESSING_THREADS);
    }

    public NodeExecutionManager(NodeInternal node, JPPFProperty<Integer> nbThreadsProperty) {
        super(JPPFConfiguration.getProperties(), nbThreadsProperty);
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        this.node = node;
    }

    protected void setup(TaskBundle bundle, List<Task<?>> taskList) {
        if (debugEnabled) {
            log.debug("setting up bundle {}", (Object)bundle);
        }
        this.bundle = bundle;
        this.taskNotificationDispatcher.setBundle(this.bundle);
        this.taskList = taskList;
        this.taskWrapperList = new ArrayList(taskList.size());
        this.dataProvider = taskList.get(0).getDataProvider();
        this.uuidList = bundle.getUuidPath().getList();
        ClassLoader taskClassLoader = null;
        try {
            taskClassLoader = this.node instanceof ClassLoaderProvider ? ((ClassLoaderProvider)((Object)this.node)).getClassLoader(this.uuidList) : NodeExecutionManager.getTaskClassLoader(taskList.get(0));
            this.usedClassLoader = this.threadManager.useClassLoader(taskClassLoader);
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getMessage((Throwable)e) + " - class loader lookup failed for uuidPath=" + this.uuidList;
            if (debugEnabled) {
                log.debug(msg, (Throwable)e);
            }
            log.warn(msg);
        }
        this.accumulatedElapsed.set(0L);
        LifeCycleEventHandler handler = this.node.getLifeCycleEventHandler();
        if (handler != null) {
            handler.fireJobStarting((JPPFDistributedJob)bundle, taskClassLoader instanceof AbstractJPPFClassLoader ? (AbstractJPPFClassLoader)taskClassLoader : null, taskList, this.dataProvider);
        }
    }

    protected void cleanup() {
        this.bundle.setParameter((Object)BundleParameter.NODE_BUNDLE_ELAPSED_PARAM, (Object)this.accumulatedElapsed.get());
        ClassLoader cl = this.usedClassLoader.getClassLoader();
        LifeCycleEventHandler handler = this.node.getLifeCycleEventHandler();
        if (handler != null) {
            handler.fireJobEnding((JPPFDistributedJob)this.bundle, cl instanceof AbstractJPPFClassLoader ? (AbstractJPPFClassLoader)cl : null, this.taskList, this.dataProvider);
        }
        this.dataProvider = null;
        this.usedClassLoader.dispose();
        this.usedClassLoader = null;
        this.bundle = null;
        this.taskNotificationDispatcher.setBundle(null);
        this.taskList = null;
        this.uuidList = null;
        this.setJobCancelled(false);
        this.taskWrapperList = null;
        this.timeoutHandler.clear();
        if (debugEnabled) {
            log.debug("cleaned up bundle {}", (Object)this.bundle);
        }
    }

    private static ClassLoader getTaskClassLoader(Task<?> task) {
        return task.getTaskClassLoader();
    }

    public void triggerConfigChanged() {
        super.triggerConfigChanged();
        NodeConfigNotifier.getInstance().sendNotification(this.node.getUuid(), JPPFConfiguration.getProperties());
    }

    protected void taskEnded(NodeTaskWrapper taskWrapper) {
        Task task = taskWrapper.getTask();
        Throwable t = task.getThrowable();
        if (this.node.isAndroid() && t instanceof ReflectiveOperationException) {
            task.setThrowable((Throwable)new JPPFTaskSerializationException(t));
        }
        super.taskEnded(taskWrapper);
    }
}

