/*
 * Decompiled with CFR 0.152.
 */
package org.jraf.klibnotion.internal.api.model.base;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jraf.klibnotion.internal.api.model.ApiConverter;
import org.jraf.klibnotion.internal.api.model.base.ApiReference;
import org.jraf.klibnotion.model.base.reference.DatabaseReference;
import org.jraf.klibnotion.model.base.reference.PageReference;
import org.jraf.klibnotion.model.base.reference.Reference;
import org.jraf.klibnotion.model.base.reference.UnknownTypeReference;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\t"}, d2={"Lorg/jraf/klibnotion/internal/api/model/base/ApiReferenceConverter;", "Lorg/jraf/klibnotion/internal/api/model/ApiConverter;", "Lorg/jraf/klibnotion/internal/api/model/base/ApiReference;", "Lorg/jraf/klibnotion/model/base/reference/Reference;", "()V", "apiToModel", "apiModel", "modelToApi", "model", "klibnotion"})
public final class ApiReferenceConverter
extends ApiConverter<ApiReference, Reference> {
    @NotNull
    public static final ApiReferenceConverter INSTANCE = new ApiReferenceConverter();

    private ApiReferenceConverter() {
    }

    @Override
    @NotNull
    public Reference apiToModel(@NotNull ApiReference apiModel) {
        Reference reference;
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        String type = apiModel.getType();
        if (Intrinsics.areEqual((Object)type, (Object)"database_id")) {
            String string = apiModel.getDatabase_id();
            Intrinsics.checkNotNull((Object)string);
            reference = new DatabaseReference(string);
        } else if (Intrinsics.areEqual((Object)type, (Object)"page_id")) {
            String string = apiModel.getPage_id();
            Intrinsics.checkNotNull((Object)string);
            reference = new PageReference(string);
        } else {
            reference = new UnknownTypeReference("(unknown)", type);
        }
        return reference;
    }

    @Override
    @NotNull
    public ApiReference modelToApi(@NotNull Reference model) {
        ApiReference apiReference;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Reference reference = model;
        if (reference instanceof DatabaseReference) {
            apiReference = new ApiReference("database_id", model.getId(), null, 4, null);
        } else if (reference instanceof PageReference) {
            apiReference = new ApiReference("page_id", null, model.getId(), 2, null);
        } else {
            if (reference instanceof UnknownTypeReference) {
                throw new IllegalStateException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return apiReference;
    }
}

