/*
 * Decompiled with CFR 0.152.
 */
package org.jraf.klibnotion.internal.api.model.block;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jraf.klibnotion.internal.api.model.ApiConverter;
import org.jraf.klibnotion.internal.api.model.ApiConverterKt;
import org.jraf.klibnotion.internal.api.model.block.ApiBlock;
import org.jraf.klibnotion.internal.api.model.block.ApiBlockChildPage;
import org.jraf.klibnotion.internal.api.model.block.ApiBlockText;
import org.jraf.klibnotion.internal.api.model.block.ApiBlockTodo;
import org.jraf.klibnotion.internal.api.model.richtext.ApiRichTextConverter;
import org.jraf.klibnotion.internal.model.block.BulletedListItemBlockImpl;
import org.jraf.klibnotion.internal.model.block.ChildPageBlockImpl;
import org.jraf.klibnotion.internal.model.block.Heading1BlockImpl;
import org.jraf.klibnotion.internal.model.block.Heading2BlockImpl;
import org.jraf.klibnotion.internal.model.block.Heading3BlockImpl;
import org.jraf.klibnotion.internal.model.block.NumberedListItemBlockImpl;
import org.jraf.klibnotion.internal.model.block.ParagraphBlockImpl;
import org.jraf.klibnotion.internal.model.block.ToDoBlockImpl;
import org.jraf.klibnotion.internal.model.block.ToggleBlockImpl;
import org.jraf.klibnotion.internal.model.block.UnknownTypeBlockImpl;
import org.jraf.klibnotion.model.block.Block;
import org.jraf.klibnotion.model.richtext.RichTextList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u000e\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jraf/klibnotion/internal/api/model/block/ApiInBlockConverter;", "Lorg/jraf/klibnotion/internal/api/model/ApiConverter;", "Lorg/jraf/klibnotion/internal/api/model/block/ApiBlock;", "Lorg/jraf/klibnotion/model/block/Block;", "()V", "apiToModel", "apiModel", "toRichTextList", "Lorg/jraf/klibnotion/model/richtext/RichTextList;", "Lorg/jraf/klibnotion/internal/api/model/block/ApiBlockText;", "Lorg/jraf/klibnotion/internal/api/model/block/ApiBlockTodo;", "klibnotion"})
public final class ApiInBlockConverter
extends ApiConverter<ApiBlock, Block> {
    @NotNull
    public static final ApiInBlockConverter INSTANCE = new ApiInBlockConverter();

    private ApiInBlockConverter() {
    }

    @Override
    @NotNull
    public Block apiToModel(@NotNull ApiBlock apiModel) {
        Block block;
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        String id = apiModel.getId();
        List children = apiModel.getHas_children() ? CollectionsKt.emptyList() : null;
        switch (apiModel.getType()) {
            case "paragraph": {
                block = new ParagraphBlockImpl(id, this.toRichTextList(apiModel.getParagraph()), children);
                break;
            }
            case "heading_1": {
                block = new Heading1BlockImpl(id, this.toRichTextList(apiModel.getHeading_1()));
                break;
            }
            case "heading_2": {
                block = new Heading2BlockImpl(id, this.toRichTextList(apiModel.getHeading_2()));
                break;
            }
            case "heading_3": {
                block = new Heading3BlockImpl(id, this.toRichTextList(apiModel.getHeading_3()));
                break;
            }
            case "bulleted_list_item": {
                block = new BulletedListItemBlockImpl(id, this.toRichTextList(apiModel.getBulleted_list_item()), children);
                break;
            }
            case "numbered_list_item": {
                block = new NumberedListItemBlockImpl(id, this.toRichTextList(apiModel.getNumbered_list_item()), children);
                break;
            }
            case "to_do": {
                RichTextList richTextList = this.toRichTextList(apiModel.getTo_do());
                ApiBlockTodo apiBlockTodo = apiModel.getTo_do();
                Intrinsics.checkNotNull((Object)apiBlockTodo);
                block = new ToDoBlockImpl(id, richTextList, apiBlockTodo.getChecked(), children);
                break;
            }
            case "toggle": {
                block = new ToggleBlockImpl(id, this.toRichTextList(apiModel.getToggle()), children);
                break;
            }
            case "child_page": {
                ApiBlockChildPage apiBlockChildPage = apiModel.getChild_page();
                Intrinsics.checkNotNull((Object)apiBlockChildPage);
                block = new ChildPageBlockImpl(id, apiBlockChildPage.getTitle());
                break;
            }
            default: {
                String type;
                block = new UnknownTypeBlockImpl(id, type);
            }
        }
        return block;
    }

    private final RichTextList toRichTextList(ApiBlockText $this$toRichTextList) {
        Intrinsics.checkNotNull((Object)$this$toRichTextList);
        return new RichTextList(ApiConverterKt.apiToModel($this$toRichTextList.getText(), (ApiConverter)ApiRichTextConverter.INSTANCE));
    }

    private final RichTextList toRichTextList(ApiBlockTodo $this$toRichTextList) {
        Intrinsics.checkNotNull((Object)$this$toRichTextList);
        return new RichTextList(ApiConverterKt.apiToModel($this$toRichTextList.getText(), (ApiConverter)ApiRichTextConverter.INSTANCE));
    }
}

