/*
 * Decompiled with CFR 0.152.
 */
package org.jraf.klibnotion.internal.api.model.date;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jraf.klibnotion.internal.api.model.ApiConverter;
import org.jraf.klibnotion.internal.api.model.date.TimestampFormatter;
import org.jraf.klibnotion.model.date.Date;
import org.jraf.klibnotion.model.date.DateOrDateTime;
import org.jraf.klibnotion.model.date.DateTime;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jraf/klibnotion/internal/api/model/date/ApiDateStringConverter;", "Lorg/jraf/klibnotion/internal/api/model/ApiConverter;", "", "Lorg/jraf/klibnotion/model/date/DateOrDateTime;", "()V", "DATE_FORMAT", "DATE_TIME_FORMAT", "apiToModel", "apiModel", "modelToApi", "model", "klibnotion"})
public final class ApiDateStringConverter
extends ApiConverter<String, DateOrDateTime> {
    @NotNull
    public static final ApiDateStringConverter INSTANCE = new ApiDateStringConverter();
    @NotNull
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    @NotNull
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    private ApiDateStringConverter() {
    }

    @Override
    @NotNull
    public DateOrDateTime apiToModel(@NotNull String apiModel) {
        DateOrDateTime dateOrDateTime;
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        try {
            dateOrDateTime = new DateTime(new TimestampFormatter(DATE_TIME_FORMAT).parse(apiModel));
        }
        catch (Exception e) {
            dateOrDateTime = new Date(new TimestampFormatter(DATE_FORMAT).parse(apiModel));
        }
        return dateOrDateTime;
    }

    @Override
    @NotNull
    public String modelToApi(@NotNull DateOrDateTime model) {
        String string;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DateOrDateTime dateOrDateTime = model;
        if (dateOrDateTime instanceof DateTime) {
            string = new TimestampFormatter(DATE_TIME_FORMAT).format(model.getTimestamp());
        } else if (dateOrDateTime instanceof Date) {
            string = new TimestampFormatter(DATE_FORMAT).format(model.getTimestamp());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

