/*
 * Decompiled with CFR 0.152.
 */
package org.jraf.klibnotion.internal.api.model.property.spec;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jraf.klibnotion.internal.api.model.ApiConverter;
import org.jraf.klibnotion.internal.api.model.ApiConverterKt;
import org.jraf.klibnotion.internal.api.model.property.ApiSelectOptionConverter;
import org.jraf.klibnotion.internal.api.model.property.spec.ApiPropertySpec;
import org.jraf.klibnotion.internal.api.model.property.spec.ApiPropertySpecFormula;
import org.jraf.klibnotion.internal.api.model.property.spec.ApiPropertySpecMultiSelect;
import org.jraf.klibnotion.internal.api.model.property.spec.ApiPropertySpecNumber;
import org.jraf.klibnotion.internal.api.model.property.spec.ApiPropertySpecRelation;
import org.jraf.klibnotion.internal.api.model.property.spec.ApiPropertySpecRollup;
import org.jraf.klibnotion.internal.api.model.property.spec.ApiPropertySpecSelect;
import org.jraf.klibnotion.internal.model.property.spec.CheckboxPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.CreatedByPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.CreatedTimePropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.DatePropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.EmailPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.FilePropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.FormulaPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.LastEditedByPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.LastEditedTimePropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.MultiSelectPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.NumberPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.PeoplePropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.PhoneNumberPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.RelationPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.RichTextPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.RollupPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.SelectPropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.TitlePropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.UnknownTypePropertySpecImpl;
import org.jraf.klibnotion.internal.model.property.spec.UrlPropertySpecImpl;
import org.jraf.klibnotion.model.property.spec.NumberPropertySpec;
import org.jraf.klibnotion.model.property.spec.PropertySpec;
import org.jraf.klibnotion.model.property.spec.RollupPropertySpec;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0004\u0012\u00020\u00050\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jraf/klibnotion/internal/api/model/property/spec/ApiPropertySpecConverter;", "Lorg/jraf/klibnotion/internal/api/model/ApiConverter;", "Lkotlin/Pair;", "", "Lorg/jraf/klibnotion/internal/api/model/property/spec/ApiPropertySpec;", "Lorg/jraf/klibnotion/model/property/spec/PropertySpec;", "()V", "apiToModel", "apiModel", "klibnotion"})
public final class ApiPropertySpecConverter
extends ApiConverter<Pair<? extends String, ? extends ApiPropertySpec>, PropertySpec> {
    @NotNull
    public static final ApiPropertySpecConverter INSTANCE = new ApiPropertySpecConverter();

    private ApiPropertySpecConverter() {
    }

    @Override
    @NotNull
    public PropertySpec apiToModel(@NotNull Pair<String, ApiPropertySpec> apiModel) {
        PropertySpec propertySpec;
        Intrinsics.checkNotNullParameter(apiModel, (String)"apiModel");
        Pair<String, ApiPropertySpec> pair = apiModel;
        String name = (String)pair.component1();
        ApiPropertySpec apiPropertySpec = (ApiPropertySpec)pair.component2();
        String id = apiPropertySpec.getId();
        switch (apiPropertySpec.getType()) {
            case "title": {
                propertySpec = new TitlePropertySpecImpl(name, id);
                break;
            }
            case "rich_text": {
                propertySpec = new RichTextPropertySpecImpl(name, id);
                break;
            }
            case "number": {
                NumberPropertySpec.NumberFormat numberFormat;
                ApiPropertySpecNumber apiPropertySpecNumber = apiPropertySpec.getNumber();
                Intrinsics.checkNotNull((Object)apiPropertySpecNumber);
                switch (apiPropertySpecNumber.getFormat()) {
                    case "number": {
                        numberFormat = NumberPropertySpec.NumberFormat.NUMBER;
                        break;
                    }
                    case "number_with_commas": {
                        numberFormat = NumberPropertySpec.NumberFormat.NUMBER_WITH_COMMAS;
                        break;
                    }
                    case "percent": {
                        numberFormat = NumberPropertySpec.NumberFormat.PERCENT;
                        break;
                    }
                    case "dollar": {
                        numberFormat = NumberPropertySpec.NumberFormat.DOLLAR;
                        break;
                    }
                    case "euro": {
                        numberFormat = NumberPropertySpec.NumberFormat.EURO;
                        break;
                    }
                    case "pound": {
                        numberFormat = NumberPropertySpec.NumberFormat.POUND;
                        break;
                    }
                    case "yen": {
                        numberFormat = NumberPropertySpec.NumberFormat.YEN;
                        break;
                    }
                    case "ruble": {
                        numberFormat = NumberPropertySpec.NumberFormat.RUBLE;
                        break;
                    }
                    case "rupee": {
                        numberFormat = NumberPropertySpec.NumberFormat.RUPEE;
                        break;
                    }
                    case "won": {
                        numberFormat = NumberPropertySpec.NumberFormat.WON;
                        break;
                    }
                    case "yuan": {
                        numberFormat = NumberPropertySpec.NumberFormat.YUAN;
                        break;
                    }
                    default: {
                        numberFormat = NumberPropertySpec.NumberFormat._UNKNOWN;
                    }
                }
                propertySpec = new NumberPropertySpecImpl(name, id, numberFormat);
                break;
            }
            case "select": {
                ApiPropertySpecSelect apiPropertySpecSelect = apiPropertySpec.getSelect();
                Intrinsics.checkNotNull((Object)apiPropertySpecSelect);
                propertySpec = new SelectPropertySpecImpl(name, id, ApiConverterKt.apiToModel(apiPropertySpecSelect.getOptions(), (ApiConverter)ApiSelectOptionConverter.INSTANCE));
                break;
            }
            case "multi_select": {
                ApiPropertySpecMultiSelect apiPropertySpecMultiSelect = apiPropertySpec.getMulti_select();
                Intrinsics.checkNotNull((Object)apiPropertySpecMultiSelect);
                propertySpec = new MultiSelectPropertySpecImpl(name, id, ApiConverterKt.apiToModel(apiPropertySpecMultiSelect.getOptions(), (ApiConverter)ApiSelectOptionConverter.INSTANCE));
                break;
            }
            case "date": {
                propertySpec = new DatePropertySpecImpl(name, id);
                break;
            }
            case "people": {
                propertySpec = new PeoplePropertySpecImpl(name, id);
                break;
            }
            case "file": {
                propertySpec = new FilePropertySpecImpl(name, id);
                break;
            }
            case "checkbox": {
                propertySpec = new CheckboxPropertySpecImpl(name, id);
                break;
            }
            case "url": {
                propertySpec = new UrlPropertySpecImpl(name, id);
                break;
            }
            case "email": {
                propertySpec = new EmailPropertySpecImpl(name, id);
                break;
            }
            case "phone_number": {
                propertySpec = new PhoneNumberPropertySpecImpl(name, id);
                break;
            }
            case "formula": {
                ApiPropertySpecFormula apiPropertySpecFormula = apiPropertySpec.getFormula();
                Intrinsics.checkNotNull((Object)apiPropertySpecFormula);
                propertySpec = new FormulaPropertySpecImpl(name, id, apiPropertySpecFormula.getExpression());
                break;
            }
            case "relation": {
                ApiPropertySpecRelation apiPropertySpecRelation = apiPropertySpec.getRelation();
                Intrinsics.checkNotNull((Object)apiPropertySpecRelation);
                propertySpec = new RelationPropertySpecImpl(name, id, apiPropertySpecRelation.getDatabase_id(), apiPropertySpec.getRelation().getSynced_property_name(), apiPropertySpec.getRelation().getSynced_property_id());
                break;
            }
            case "rollup": {
                RollupPropertySpec.RollupFunction rollupFunction;
                Object object = apiPropertySpec.getRollup();
                Intrinsics.checkNotNull((Object)object);
                String string = ((ApiPropertySpecRollup)object).getRelation_property_name();
                String string2 = apiPropertySpec.getRollup().getRelation_property_id();
                String string3 = apiPropertySpec.getRollup().getRollup_property_name();
                String string4 = apiPropertySpec.getRollup().getRollup_property_id();
                switch (apiPropertySpec.getRollup().getFunction()) {
                    case "count_all": {
                        rollupFunction = RollupPropertySpec.RollupFunction.COUNT_ALL;
                        break;
                    }
                    case "count_values": {
                        rollupFunction = RollupPropertySpec.RollupFunction.COUNT_VALUES;
                        break;
                    }
                    case "count_unique_values": {
                        rollupFunction = RollupPropertySpec.RollupFunction.COUNT_UNIQUE_VALUES;
                        break;
                    }
                    case "count_empty": {
                        rollupFunction = RollupPropertySpec.RollupFunction.COUNT_EMPTY;
                        break;
                    }
                    case "count_not_empty": {
                        rollupFunction = RollupPropertySpec.RollupFunction.COUNT_NOT_EMPTY;
                        break;
                    }
                    case "percent_empty": {
                        rollupFunction = RollupPropertySpec.RollupFunction.PERCENT_EMPTY;
                        break;
                    }
                    case "percent_not_empty": {
                        rollupFunction = RollupPropertySpec.RollupFunction.PERCENT_NOT_EMPTY;
                        break;
                    }
                    case "sum": {
                        rollupFunction = RollupPropertySpec.RollupFunction.SUM;
                        break;
                    }
                    case "average": {
                        rollupFunction = RollupPropertySpec.RollupFunction.AVERAGE;
                        break;
                    }
                    case "median": {
                        rollupFunction = RollupPropertySpec.RollupFunction.MEDIAN;
                        break;
                    }
                    case "min": {
                        rollupFunction = RollupPropertySpec.RollupFunction.MIN;
                        break;
                    }
                    case "max": {
                        rollupFunction = RollupPropertySpec.RollupFunction.MAX;
                        break;
                    }
                    case "range": {
                        rollupFunction = RollupPropertySpec.RollupFunction.RANGE;
                        break;
                    }
                    default: {
                        rollupFunction = RollupPropertySpec.RollupFunction._UNKNOWN;
                    }
                }
                propertySpec = new RollupPropertySpecImpl(name, id, string, string2, string3, string4, rollupFunction);
                break;
            }
            case "created_time": {
                propertySpec = new CreatedTimePropertySpecImpl(name, id);
                break;
            }
            case "created_by": {
                propertySpec = new CreatedByPropertySpecImpl(name, id);
                break;
            }
            case "last_edited_time": {
                propertySpec = new LastEditedTimePropertySpecImpl(name, id);
                break;
            }
            case "last_edited_by": {
                propertySpec = new LastEditedByPropertySpecImpl(name, id);
                break;
            }
            default: {
                String string = apiPropertySpec.getType();
                propertySpec = new UnknownTypePropertySpecImpl(id, name, string);
            }
        }
        return propertySpec;
    }
}

