/*
 * Decompiled with CFR 0.152.
 */
package org.jraf.klibnotion.internal.api.model.property.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jraf.klibnotion.internal.api.model.ApiConverter;
import org.jraf.klibnotion.internal.api.model.ApiConverterKt;
import org.jraf.klibnotion.internal.api.model.base.ApiNumberConverter;
import org.jraf.klibnotion.internal.api.model.date.ApiDate;
import org.jraf.klibnotion.internal.api.model.date.ApiDateConverter;
import org.jraf.klibnotion.internal.api.model.date.ApiDateStringConverter;
import org.jraf.klibnotion.internal.api.model.file.ApiFile;
import org.jraf.klibnotion.internal.api.model.file.ApiFileConverter;
import org.jraf.klibnotion.internal.api.model.property.ApiSelectOption;
import org.jraf.klibnotion.internal.api.model.property.ApiSelectOptionConverter;
import org.jraf.klibnotion.internal.api.model.property.value.ApiPropertyValue;
import org.jraf.klibnotion.internal.api.model.property.value.ApiPropertyValueRelation;
import org.jraf.klibnotion.internal.api.model.property.value.formula.ApiPropertyValueFormulaConverter;
import org.jraf.klibnotion.internal.api.model.property.value.rollup.ApiPropertyValueRollupConverter;
import org.jraf.klibnotion.internal.api.model.richtext.ApiRichText;
import org.jraf.klibnotion.internal.api.model.richtext.ApiRichTextConverter;
import org.jraf.klibnotion.internal.api.model.user.ApiUser;
import org.jraf.klibnotion.internal.api.model.user.ApiUserConverter;
import org.jraf.klibnotion.internal.model.property.value.CheckboxPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.CreatedByPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.CreatedTimePropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.DatePropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.EmailPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.FilesPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.LastEditedByPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.LastEditedTimePropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.MultiSelectPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.NumberPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.PeoplePropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.PhoneNumberPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.RelationPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.RichTextPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.SelectPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.TitlePropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.UnknownTypePropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.UrlPropertyValueImpl;
import org.jraf.klibnotion.model.property.value.PropertyValue;
import org.jraf.klibnotion.model.richtext.RichTextList;
import org.jraf.klibnotion.model.user.User;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jraf/klibnotion/internal/api/model/property/value/ApiPropertyValueConverter;", "Lorg/jraf/klibnotion/internal/api/model/ApiConverter;", "Lkotlin/Pair;", "", "Lorg/jraf/klibnotion/internal/api/model/property/value/ApiPropertyValue;", "Lorg/jraf/klibnotion/model/property/value/PropertyValue;", "()V", "apiToModel", "apiModel", "klibnotion"})
public final class ApiPropertyValueConverter
extends ApiConverter<Pair<? extends String, ? extends ApiPropertyValue>, PropertyValue<?>> {
    @NotNull
    public static final ApiPropertyValueConverter INSTANCE = new ApiPropertyValueConverter();

    private ApiPropertyValueConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PropertyValue<?> apiToModel(@NotNull Pair<String, ApiPropertyValue> apiModel) {
        PropertyValue propertyValue;
        Intrinsics.checkNotNullParameter(apiModel, (String)"apiModel");
        Pair<String, ApiPropertyValue> pair = apiModel;
        String name = (String)pair.component1();
        ApiPropertyValue apiPropertyValue = (ApiPropertyValue)pair.component2();
        String id = apiPropertyValue.getId();
        switch (apiPropertyValue.getType()) {
            case "rich_text": {
                List<ApiRichText> list = apiPropertyValue.getRich_text();
                Intrinsics.checkNotNull(list);
                propertyValue = new RichTextPropertyValueImpl(id, name, new RichTextList(ApiConverterKt.apiToModel(list, (ApiConverter)ApiRichTextConverter.INSTANCE)));
                break;
            }
            case "number": {
                String string = apiPropertyValue.getNumber();
                Intrinsics.checkNotNull((Object)string);
                propertyValue = new NumberPropertyValueImpl(id, name, ApiNumberConverter.INSTANCE.apiToModel(string));
                break;
            }
            case "select": {
                ApiSelectOption apiSelectOption = apiPropertyValue.getSelect();
                Intrinsics.checkNotNull((Object)apiSelectOption);
                propertyValue = new SelectPropertyValueImpl(id, name, ApiSelectOptionConverter.INSTANCE.apiToModel(apiSelectOption));
                break;
            }
            case "multi_select": {
                List<ApiSelectOption> list = apiPropertyValue.getMulti_select();
                Intrinsics.checkNotNull(list);
                propertyValue = new MultiSelectPropertyValueImpl(id, name, ApiSelectOptionConverter.INSTANCE.apiToModel(list));
                break;
            }
            case "date": {
                ApiDate apiDate = apiPropertyValue.getDate();
                Intrinsics.checkNotNull((Object)apiDate);
                propertyValue = new DatePropertyValueImpl(id, name, ApiDateConverter.INSTANCE.apiToModel(apiDate));
                break;
            }
            case "formula": {
                propertyValue = ApiPropertyValueFormulaConverter.INSTANCE.apiToModel(apiModel);
                break;
            }
            case "relation": {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable<ApiPropertyValueRelation> iterable = apiPropertyValue.getRelation();
                Intrinsics.checkNotNull(iterable);
                iterable = iterable;
                String string = name;
                String string2 = id;
                boolean $i$f$map = false;
                void var9_27 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ApiPropertyValueRelation apiPropertyValueRelation = (ApiPropertyValueRelation)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string3 = it.getId();
                    collection.add(string3);
                }
                collection = (List)destination$iv$iv;
                List list = collection;
                String string4 = string;
                String string5 = string2;
                propertyValue = new RelationPropertyValueImpl(string5, string4, list);
                break;
            }
            case "rollup": {
                propertyValue = ApiPropertyValueRollupConverter.INSTANCE.apiToModel(apiModel);
                break;
            }
            case "title": {
                List<ApiRichText> list = apiPropertyValue.getTitle();
                Intrinsics.checkNotNull(list);
                propertyValue = new TitlePropertyValueImpl(id, name, new RichTextList(ApiConverterKt.apiToModel(list, (ApiConverter)ApiRichTextConverter.INSTANCE)));
                break;
            }
            case "people": {
                List<ApiUser> list = apiPropertyValue.getPeople();
                Intrinsics.checkNotNull(list);
                propertyValue = new PeoplePropertyValueImpl(id, name, ApiConverterKt.apiToModel(list, (ApiConverter)ApiUserConverter.INSTANCE));
                break;
            }
            case "files": {
                List<ApiFile> list = apiPropertyValue.getFiles();
                Intrinsics.checkNotNull(list);
                propertyValue = new FilesPropertyValueImpl(id, name, ApiConverterKt.apiToModel(list, (ApiConverter)ApiFileConverter.INSTANCE));
                break;
            }
            case "checkbox": {
                Boolean bl = apiPropertyValue.getCheckbox();
                Intrinsics.checkNotNull((Object)bl);
                propertyValue = new CheckboxPropertyValueImpl(id, name, bl);
                break;
            }
            case "url": {
                String string = apiPropertyValue.getUrl();
                Intrinsics.checkNotNull((Object)string);
                propertyValue = new UrlPropertyValueImpl(id, name, string);
                break;
            }
            case "email": {
                String string = apiPropertyValue.getEmail();
                Intrinsics.checkNotNull((Object)string);
                propertyValue = new EmailPropertyValueImpl(id, name, string);
                break;
            }
            case "phone_number": {
                String string = apiPropertyValue.getPhone_number();
                Intrinsics.checkNotNull((Object)string);
                propertyValue = new PhoneNumberPropertyValueImpl(id, name, string);
                break;
            }
            case "created_time": {
                String string = apiPropertyValue.getCreated_time();
                Intrinsics.checkNotNull((Object)string);
                propertyValue = new CreatedTimePropertyValueImpl(id, name, ApiDateStringConverter.INSTANCE.apiToModel(string));
                break;
            }
            case "created_by": {
                ApiUser apiUser = apiPropertyValue.getCreated_by();
                Intrinsics.checkNotNull((Object)apiUser);
                propertyValue = new CreatedByPropertyValueImpl(id, name, (User)ApiConverterKt.apiToModel(apiUser, (ApiConverter)ApiUserConverter.INSTANCE));
                break;
            }
            case "last_edited_time": {
                String string = apiPropertyValue.getLast_edited_time();
                Intrinsics.checkNotNull((Object)string);
                propertyValue = new LastEditedTimePropertyValueImpl(id, name, ApiDateStringConverter.INSTANCE.apiToModel(string));
                break;
            }
            case "last_edited_by": {
                ApiUser apiUser = apiPropertyValue.getLast_edited_by();
                Intrinsics.checkNotNull((Object)apiUser);
                propertyValue = new LastEditedByPropertyValueImpl(id, name, (User)ApiConverterKt.apiToModel(apiUser, (ApiConverter)ApiUserConverter.INSTANCE));
                break;
            }
            default: {
                String type;
                propertyValue = new UnknownTypePropertyValueImpl(id, name, type, null, 8, null);
            }
        }
        return propertyValue;
    }
}

