/*
 * Decompiled with CFR 0.152.
 */
package org.jraf.klibnotion.internal.api.model.property.value.formula;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jraf.klibnotion.internal.api.model.ApiConverter;
import org.jraf.klibnotion.internal.api.model.ApiConverterKt;
import org.jraf.klibnotion.internal.api.model.base.ApiNumberConverter;
import org.jraf.klibnotion.internal.api.model.date.ApiDate;
import org.jraf.klibnotion.internal.api.model.date.ApiDateConverter;
import org.jraf.klibnotion.internal.api.model.property.value.ApiPropertyValue;
import org.jraf.klibnotion.internal.api.model.property.value.ApiPropertyValueFormula;
import org.jraf.klibnotion.internal.model.property.value.formula.BooleanFormulaPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.formula.DateFormulaPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.formula.NumberFormulaPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.formula.StringFormulaPropertyValueImpl;
import org.jraf.klibnotion.internal.model.property.value.formula.UnknownTypeFormulaPropertyValueImpl;
import org.jraf.klibnotion.model.date.DateOrDateRange;
import org.jraf.klibnotion.model.property.value.FormulaPropertyValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jraf/klibnotion/internal/api/model/property/value/formula/ApiPropertyValueFormulaConverter;", "Lorg/jraf/klibnotion/internal/api/model/ApiConverter;", "Lkotlin/Pair;", "", "Lorg/jraf/klibnotion/internal/api/model/property/value/ApiPropertyValue;", "Lorg/jraf/klibnotion/model/property/value/FormulaPropertyValue;", "()V", "apiToModel", "apiModel", "klibnotion"})
public final class ApiPropertyValueFormulaConverter
extends ApiConverter<Pair<? extends String, ? extends ApiPropertyValue>, FormulaPropertyValue<?>> {
    @NotNull
    public static final ApiPropertyValueFormulaConverter INSTANCE = new ApiPropertyValueFormulaConverter();

    private ApiPropertyValueFormulaConverter() {
    }

    @Override
    @NotNull
    public FormulaPropertyValue<?> apiToModel(@NotNull Pair<String, ApiPropertyValue> apiModel) {
        FormulaPropertyValue formulaPropertyValue;
        Intrinsics.checkNotNullParameter(apiModel, (String)"apiModel");
        Pair<String, ApiPropertyValue> pair = apiModel;
        String name = (String)pair.component1();
        ApiPropertyValue apiPropertyValue = (ApiPropertyValue)pair.component2();
        String id = apiPropertyValue.getId();
        ApiPropertyValueFormula apiPropertyValueFormula = apiPropertyValue.getFormula();
        Intrinsics.checkNotNull((Object)apiPropertyValueFormula);
        ApiPropertyValueFormula formula = apiPropertyValueFormula;
        switch (formula.getType()) {
            case "string": {
                String string = formula.getString();
                Intrinsics.checkNotNull((Object)string);
                formulaPropertyValue = new StringFormulaPropertyValueImpl(id, name, string);
                break;
            }
            case "number": {
                String string = formula.getNumber();
                Intrinsics.checkNotNull((Object)string);
                formulaPropertyValue = new NumberFormulaPropertyValueImpl(id, name, (Number)ApiConverterKt.apiToModel(string, (ApiConverter)ApiNumberConverter.INSTANCE));
                break;
            }
            case "boolean": {
                Boolean bl = formula.getBoolean();
                Intrinsics.checkNotNull((Object)bl);
                formulaPropertyValue = new BooleanFormulaPropertyValueImpl(id, name, bl);
                break;
            }
            case "date": {
                ApiDate apiDate = formula.getDate();
                Intrinsics.checkNotNull((Object)apiDate);
                formulaPropertyValue = new DateFormulaPropertyValueImpl(id, name, (DateOrDateRange)ApiConverterKt.apiToModel(apiDate, (ApiConverter)ApiDateConverter.INSTANCE));
                break;
            }
            default: {
                String type;
                formulaPropertyValue = new UnknownTypeFormulaPropertyValueImpl(id, name, type, null, 8, null);
            }
        }
        return formulaPropertyValue;
    }
}

