/*
 * Decompiled with CFR 0.152.
 */
package org.jraf.klibnotion.internal.api.model.richtext;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jraf.klibnotion.internal.api.model.ApiConverter;
import org.jraf.klibnotion.internal.api.model.date.ApiDate;
import org.jraf.klibnotion.internal.api.model.date.ApiDateConverter;
import org.jraf.klibnotion.internal.api.model.richtext.ApiAnnotationsConverter;
import org.jraf.klibnotion.internal.api.model.richtext.ApiLink;
import org.jraf.klibnotion.internal.api.model.richtext.ApiRichText;
import org.jraf.klibnotion.internal.api.model.richtext.ApiRichTextEquation;
import org.jraf.klibnotion.internal.api.model.richtext.ApiRichTextMention;
import org.jraf.klibnotion.internal.api.model.richtext.ApiRichTextMentionDatabase;
import org.jraf.klibnotion.internal.api.model.richtext.ApiRichTextMentionPage;
import org.jraf.klibnotion.internal.api.model.richtext.ApiRichTextText;
import org.jraf.klibnotion.internal.api.model.user.ApiUser;
import org.jraf.klibnotion.internal.api.model.user.ApiUserConverter;
import org.jraf.klibnotion.internal.model.richtext.EquationRichTextImpl;
import org.jraf.klibnotion.internal.model.richtext.TextRichTextImpl;
import org.jraf.klibnotion.internal.model.richtext.UnknownTypeRichTextImpl;
import org.jraf.klibnotion.internal.model.richtext.mention.DatabaseMentionRichTextImpl;
import org.jraf.klibnotion.internal.model.richtext.mention.DateMentionRichTextImpl;
import org.jraf.klibnotion.internal.model.richtext.mention.PageMentionRichTextImpl;
import org.jraf.klibnotion.internal.model.richtext.mention.UnknownTypeMentionRichTextImpl;
import org.jraf.klibnotion.internal.model.richtext.mention.UserMentionRichTextImpl;
import org.jraf.klibnotion.model.richtext.Annotations;
import org.jraf.klibnotion.model.richtext.MentionRichText;
import org.jraf.klibnotion.model.richtext.RichText;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jraf/klibnotion/internal/api/model/richtext/ApiRichTextConverter;", "Lorg/jraf/klibnotion/internal/api/model/ApiConverter;", "Lorg/jraf/klibnotion/internal/api/model/richtext/ApiRichText;", "Lorg/jraf/klibnotion/model/richtext/RichText;", "()V", "apiToModel", "apiModel", "klibnotion"})
public final class ApiRichTextConverter
extends ApiConverter<ApiRichText, RichText> {
    @NotNull
    public static final ApiRichTextConverter INSTANCE = new ApiRichTextConverter();

    private ApiRichTextConverter() {
    }

    @Override
    @NotNull
    public RichText apiToModel(@NotNull ApiRichText apiModel) {
        RichText richText;
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        String plainText2 = apiModel.getPlain_text();
        String href = apiModel.getHref();
        Annotations annotations = ApiAnnotationsConverter.INSTANCE.apiToModel(apiModel.getAnnotations());
        switch (apiModel.getType()) {
            case "text": {
                ApiRichTextText apiRichTextText = apiModel.getText();
                Intrinsics.checkNotNull((Object)apiRichTextText);
                ApiLink apiLink = apiRichTextText.getLink();
                richText = new TextRichTextImpl(plainText2, href, annotations, apiLink == null ? null : apiLink.getUrl());
                break;
            }
            case "mention": {
                MentionRichText mentionRichText;
                Object object = apiModel.getMention();
                Intrinsics.checkNotNull((Object)object);
                switch (((ApiRichTextMention)object).getType()) {
                    case "user": {
                        object = apiModel.getMention().getUser();
                        Intrinsics.checkNotNull((Object)object);
                        mentionRichText = new UserMentionRichTextImpl(plainText2, href, annotations, ApiUserConverter.INSTANCE.apiToModel((ApiUser)object));
                        break;
                    }
                    case "page": {
                        object = apiModel.getMention().getPage();
                        Intrinsics.checkNotNull((Object)object);
                        mentionRichText = new PageMentionRichTextImpl(plainText2, href, annotations, ((ApiRichTextMentionPage)object).getId());
                        break;
                    }
                    case "database": {
                        object = apiModel.getMention().getDatabase();
                        Intrinsics.checkNotNull((Object)object);
                        mentionRichText = new DatabaseMentionRichTextImpl(plainText2, href, annotations, ((ApiRichTextMentionDatabase)object).getId());
                        break;
                    }
                    case "date": {
                        object = apiModel.getMention().getDate();
                        Intrinsics.checkNotNull((Object)object);
                        mentionRichText = new DateMentionRichTextImpl(plainText2, href, annotations, ApiDateConverter.INSTANCE.apiToModel((ApiDate)object));
                        break;
                    }
                    default: {
                        mentionRichText = new UnknownTypeMentionRichTextImpl(plainText2, href, annotations, apiModel.getMention().getType());
                    }
                }
                richText = mentionRichText;
                break;
            }
            case "equation": {
                ApiRichTextEquation apiRichTextEquation = apiModel.getEquation();
                Intrinsics.checkNotNull((Object)apiRichTextEquation);
                richText = new EquationRichTextImpl(plainText2, href, annotations, apiRichTextEquation.getExpression());
                break;
            }
            default: {
                richText = new UnknownTypeRichTextImpl(plainText2, href, annotations, apiModel.getType());
            }
        }
        return richText;
    }
}

